/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class AUUC
extends Iced {
    public final int _nBins;
    public final int _maxIdx;
    public final double[] _ths;
    public final long[] _treatment;
    public final long[] _control;
    public final long[] _yTreatment;
    public final long[] _yControl;
    public final long[] _frequency;
    public final long[] _frequencyCumsum;
    public double[][] _uplift;
    public double[][] _upliftRandom;
    public double[][] _upliftNormalized;
    public final long _n;
    public static final int NBINS = 1000;
    public final AUUCType _auucType;
    public final int _auucTypeIndx;
    public double[] _auucs;
    public double[] _auucsRandom;
    public double[] _aecu;
    public double[] _auucsNormalized;

    public double threshold(int idx) {
        return this._ths[idx];
    }

    public long treatment(int idx) {
        return this._treatment[idx];
    }

    public long control(int idx) {
        return this._control[idx];
    }

    public long yTreatment(int idx) {
        return this._yTreatment[idx];
    }

    public long yControl(int idx) {
        return this._yControl[idx];
    }

    public long frequency(int idx) {
        return this._frequency[idx];
    }

    public double uplift(int idx) {
        return this._uplift[this._auucTypeIndx][idx];
    }

    private int getIndexByAUUCType(AUUCType type) {
        return ArrayUtils.find(AUUCType.VALUES, type);
    }

    public double[] upliftByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return idx < 0 ? null : this._uplift[idx];
    }

    public double[] upliftNormalizedByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return idx < 0 ? null : this._upliftNormalized[idx];
    }

    public double[] upliftRandomByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return idx < 0 ? null : this._upliftRandom[idx];
    }

    public AUUC(Vec probs, Vec y, Vec uplift, AUUCType auucType, int nbins) {
        this(((AUUCImpl)new AUUCImpl((double[])AUUC.calculateQuantileThresholds((int)nbins, (Vec)probs)).doAll((Vec[])new Vec[]{probs, y, uplift}))._bldr, auucType);
    }

    public AUUC(AUUCBuilder bldr, AUUCType auucType) {
        this(bldr, true, auucType);
    }

    public AUUC(double[] customThresholds, Vec probs, Vec y, Vec uplift, AUUCType auucType) {
        this(((AUUCImpl)new AUUCImpl((double[])customThresholds).doAll((Vec[])new Vec[]{probs, y, uplift}))._bldr, auucType);
    }

    public AUUC(AUUCBuilder bldr, boolean trueProbabilities, AUUCType auucType) {
        this._auucType = auucType;
        this._auucTypeIndx = this.getIndexByAUUCType(this._auucType);
        this._nBins = bldr._nBins;
        if (this._nBins > 0) {
            assert (trueProbabilities || bldr._thresholds[this._nBins - 1] == 1.0) : "Bins need to contain pred = 1 when 0-1 probabilities are used";
            this._n = bldr._n;
            this._ths = Arrays.copyOf(bldr._thresholds, this._nBins);
            this._treatment = Arrays.copyOf(bldr._treatment, this._nBins);
            this._control = Arrays.copyOf(bldr._control, this._nBins);
            this._yTreatment = Arrays.copyOf(bldr._yTreatment, this._nBins);
            this._yControl = Arrays.copyOf(bldr._yControl, this._nBins);
            this._frequency = Arrays.copyOf(bldr._frequency, this._nBins);
            this._frequencyCumsum = Arrays.copyOf(bldr._frequency, this._nBins);
            this._uplift = new double[AUUCType.values().length][this._nBins];
            this._upliftRandom = new double[AUUCType.values().length][this._nBins];
            this._upliftNormalized = new double[AUUCType.values().length][this._nBins];
            long tmpt = 0L;
            long tmpc = 0L;
            long tmptp = 0L;
            long tmpcp = 0L;
            long tmpf = 0L;
            for (int i = 0; i < this._nBins; ++i) {
                this._treatment[i] = tmpt += this._treatment[i];
                this._control[i] = tmpc += this._control[i];
                this._yTreatment[i] = tmptp += this._yTreatment[i];
                this._yControl[i] = tmpcp += this._yControl[i];
                this._frequencyCumsum[i] = tmpf += this._frequencyCumsum[i];
            }
            this.setUplift();
            this.setUpliftRandom();
            this.setUpliftNormalized();
            if (trueProbabilities) {
                this._auucs = this.computeAuucs();
                this._auucsRandom = this.computeAuucsRandom();
                this._aecu = this.computeAecu();
                this._auucsNormalized = this.computeAuucsNormalized();
                this._maxIdx = this._auucType.maxCriterionIdx(this);
            } else {
                this._maxIdx = 0;
            }
        } else {
            this._maxIdx = -1;
            this._n = 0L;
            this._ths = null;
            this._treatment = null;
            this._control = null;
            this._yTreatment = null;
            this._yControl = null;
            this._frequency = null;
            this._frequencyCumsum = null;
            this._uplift = null;
            this._upliftRandom = null;
            this._upliftNormalized = null;
        }
    }

    public void setUplift() {
        int i;
        for (i = 0; i < AUUCType.VALUES.length; ++i) {
            for (int j = 0; j < this._nBins; ++j) {
                this._uplift[i][j] = AUUCType.VALUES[i].exec(this, j);
            }
        }
        for (i = 0; i < AUUCType.VALUES.length; ++i) {
            if (this._uplift[i].length == 1 && Double.isNaN(this._uplift[i][0])) {
                this._uplift[i][0] = 0.0;
                continue;
            }
            ArrayUtils.interpolateLinear(this._uplift[i]);
        }
    }

    public void setUpliftRandom() {
        for (int i = 0; i < AUUCType.VALUES.length; ++i) {
            int maxIndex = this._nBins - 1;
            double a = this._uplift[i][maxIndex] / (double)this._frequencyCumsum[maxIndex];
            for (int j = 0; j < this._nBins; ++j) {
                this._upliftRandom[i][j] = a * (double)this._frequencyCumsum[j];
            }
        }
    }

    public void setUpliftNormalized() {
        for (int i = 0; i < AUUCType.VALUES.length; ++i) {
            int maxIndex = this._nBins - 1;
            int liftIndex = this.getIndexByAUUCType(AUUCType.lift);
            double a = i == liftIndex || this._uplift[i][maxIndex] == 0.0 ? 1.0 : Math.abs(this._uplift[i][maxIndex]);
            for (int j = 0; j < this._nBins; ++j) {
                this._upliftNormalized[i][j] = this._uplift[i][j] / a;
            }
        }
    }

    public AUUC() {
        this._nBins = 0;
        this._n = 0L;
        this._ths = new double[0];
        this._frequencyCumsum = new long[0];
        this._frequency = this._frequencyCumsum;
        this._yControl = this._frequencyCumsum;
        this._yTreatment = this._frequencyCumsum;
        this._control = this._frequencyCumsum;
        this._treatment = this._frequencyCumsum;
        this._auucs = new double[AUUCType.VALUES.length];
        Arrays.fill(this._auucs, Double.NaN);
        this._auucsNormalized = new double[AUUCType.VALUES.length];
        Arrays.fill(this._auucsNormalized, Double.NaN);
        this._auucsRandom = new double[AUUCType.VALUES.length];
        Arrays.fill(this._auucsRandom, Double.NaN);
        this._aecu = new double[AUUCType.VALUES.length];
        Arrays.fill(this._aecu, Double.NaN);
        this._maxIdx = -1;
        this._auucType = AUUCType.AUTO;
        this._auucTypeIndx = this.getIndexByAUUCType(this._auucType);
        this._uplift = new double[AUUCType.values().length][];
        this._upliftNormalized = new double[AUUCType.values().length][];
        this._upliftRandom = new double[AUUCType.values().length][];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] calculateQuantileThresholds(int groups, Vec preds) {
        double[] quantiles;
        Frame fr = null;
        Keyed qm = null;
        try {
            QuantileModel.QuantileParameters qp = new QuantileModel.QuantileParameters();
            qp._seed = 42L;
            fr = new Frame(Key.make(), new String[]{"predictions"}, new Vec[]{preds});
            DKV.put(fr);
            qp._train = fr._key;
            assert (groups > 0);
            qp._probs = new double[groups];
            for (int i = 0; i < groups; ++i) {
                qp._probs[i] = ((double)(groups - i) - 1.0) / (double)groups;
            }
            qm = (QuantileModel)new Quantile(qp).trainModel().get();
            quantiles = ((QuantileModel.QuantileOutput)((QuantileModel)qm)._output)._quantiles[0];
            TreeSet<Double> hs = new TreeSet<Double>();
            for (double d : quantiles) {
                hs.add(d);
            }
            quantiles = new double[hs.size()];
            Iterator it = hs.descendingIterator();
            int i = 0;
            while (it.hasNext()) {
                quantiles[i++] = (Double)it.next();
            }
        }
        finally {
            if (qm != null) {
                qm.remove();
            }
            if (fr != null) {
                DKV.remove(fr._key);
            }
        }
        if (quantiles == null) {
            quantiles = new double[]{0.0};
        } else if (Double.isNaN(quantiles[0])) {
            quantiles[0] = 0.0;
        }
        return quantiles;
    }

    private double[] computeAuucs() {
        return this.computeAuucs(this._uplift);
    }

    private double[] computeAuucsRandom() {
        return this.computeAuucs(this._upliftRandom);
    }

    private double[] computeAuucsNormalized() {
        return this.computeAuucs(this._upliftNormalized);
    }

    private double[] computeAuucs(double[][] uplift) {
        AUUCType[] auucTypes = AUUCType.VALUES;
        double[] auucs = new double[auucTypes.length];
        for (int i = 0; i < auucTypes.length; ++i) {
            if (this._n == 0L) {
                auucs[i] = Double.NaN;
                continue;
            }
            double area = 0.0;
            for (int j = 0; j < this._nBins; ++j) {
                area += uplift[i][j] * (double)this.frequency(j);
            }
            auucs[i] = area / (double)(this._n + 1L);
        }
        return auucs;
    }

    private double[] computeAecu() {
        double[] aecu = new double[this._auucs.length];
        for (int i = 0; i < this._auucs.length; ++i) {
            aecu[i] = this.auuc(i) - this.auucRandom(i);
        }
        return aecu;
    }

    public double auucByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return this.auuc(idx);
    }

    public double auucRandomByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return this.auucRandom(idx);
    }

    public double aecuByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return this.aecu(idx);
    }

    public double auucNormalizedByType(AUUCType type) {
        int idx = this.getIndexByAUUCType(type);
        return this.auucNormalized(idx);
    }

    public double auuc(int idx) {
        return this._n == 0L || idx < 0 ? Double.NaN : this._auucs[idx];
    }

    public double auuc() {
        return this.auuc(this._auucTypeIndx);
    }

    public double auucRandom(int idx) {
        return this._n == 0L || idx < 0 ? Double.NaN : this._auucsRandom[idx];
    }

    public double auucRandom() {
        return this.auucRandom(this._auucTypeIndx);
    }

    public double aecu(int idx) {
        return this._n == 0L || idx < 0 ? Double.NaN : this._aecu[idx];
    }

    public double qini() {
        return this.aecuByType(AUUCType.qini);
    }

    public double auucNormalized(int idx) {
        return this._n == 0L || idx < 0 ? Double.NaN : this._auucsNormalized[idx];
    }

    public double auucNormalized() {
        return this.auucNormalized(this._auucTypeIndx);
    }

    public static enum AUUCType {
        AUTO{

            @Override
            double exec(long treatment, long control, long yTreatment, long yControl) {
                return qini.exec(treatment, control, yTreatment, yControl);
            }
        }
        ,
        qini{

            @Override
            double exec(long treatment, long control, long yTreatment, long yControl) {
                double norm = (double)treatment / (double)control;
                return (double)yTreatment - (double)yControl * norm;
            }
        }
        ,
        lift{

            @Override
            double exec(long treatment, long control, long yTreatment, long yControl) {
                return (double)yTreatment / (double)treatment - (double)yControl / (double)control;
            }
        }
        ,
        gain{

            @Override
            double exec(long treatment, long control, long yTreatment, long yControl) {
                return lift.exec(treatment, control, yTreatment, yControl) * (double)(treatment + control);
            }
        };

        public static final AUUCType[] VALUES;

        abstract double exec(long var1, long var3, long var5, long var7);

        public double exec(AUUC auc, int idx) {
            return this.exec(auc.treatment(idx), auc.control(idx), auc.yTreatment(idx), auc.yControl(idx));
        }

        public static AUUCType fromString(String strRepr) {
            for (AUUCType tc : AUUCType.values()) {
                if (!tc.toString().equalsIgnoreCase(strRepr)) continue;
                return tc;
            }
            return null;
        }

        public double maxCriterion(AUUC auuc) {
            return this.exec(auuc, this.maxCriterionIdx(auuc));
        }

        public int maxCriterionIdx(AUUC auuc) {
            double md = -1.7976931348623157E308;
            int mx = -1;
            for (int i = 0; i < auuc._nBins; ++i) {
                double d = this.exec(auuc, i);
                if (!(d > md)) continue;
                md = d;
                mx = i;
            }
            return mx;
        }

        static {
            VALUES = AUUCType.values();
        }
    }

    public static class AUUCBuilder
    extends Iced {
        final int _nBins;
        final double[] _thresholds;
        final long[] _treatment;
        final long[] _control;
        final long[] _yTreatment;
        final long[] _yControl;
        final long[] _frequency;
        long _n;

        public AUUCBuilder(double[] thresholds) {
            int nBins;
            this._nBins = nBins = thresholds.length;
            this._thresholds = thresholds;
            this._treatment = new long[nBins];
            this._control = new long[nBins];
            this._yTreatment = new long[nBins];
            this._yControl = new long[nBins];
            this._frequency = new long[nBins];
        }

        public void perRow(double pred, double w, double y, float treatment) {
            if (w == 0.0) {
                return;
            }
            for (int t = 0; t < this._thresholds.length; ++t) {
                if (!(pred >= this._thresholds[t]) || t != 0 && !(pred < this._thresholds[t - 1])) continue;
                ++this._n;
                int n = t;
                this._frequency[n] = this._frequency[n] + 1L;
                if (treatment == 1.0f) {
                    int n2 = t;
                    this._treatment[n2] = this._treatment[n2] + 1L;
                    if (y != 1.0) break;
                    int n3 = t;
                    this._yTreatment[n3] = this._yTreatment[n3] + 1L;
                    break;
                }
                int n4 = t;
                this._control[n4] = this._control[n4] + 1L;
                if (y != 1.0) break;
                int n5 = t;
                this._yControl[n5] = this._yControl[n5] + 1L;
                break;
            }
        }

        public void reduce(AUUCBuilder bldr) {
            this._n += bldr._n;
            ArrayUtils.add(this._treatment, bldr._treatment);
            ArrayUtils.add(this._control, bldr._control);
            ArrayUtils.add(this._yTreatment, bldr._yTreatment);
            ArrayUtils.add(this._yControl, bldr._yControl);
            ArrayUtils.add(this._frequency, bldr._frequency);
        }

        private String toDebugString() {
            return "n =" + this._n + "; nBins = " + this._nBins + "; ths = " + Arrays.toString(this._thresholds) + "; treatment = " + Arrays.toString(this._treatment) + "; contribution = " + Arrays.toString(this._control) + "; yTreatment = " + Arrays.toString(this._yTreatment) + "; yContribution = " + Arrays.toString(this._yControl) + "; frequency = " + Arrays.toString(this._frequency);
        }
    }

    public static class AUUCImpl
    extends MRTask<AUUCImpl> {
        final double[] _thresholds;
        AUUCBuilder _bldr;

        public AUUCImpl(double[] thresholds) {
            this._thresholds = thresholds;
        }

        @Override
        public void map(Chunk ps, Chunk actuals, Chunk treatment) {
            AUUCBuilder bldr = this._bldr = new AUUCBuilder(this._thresholds);
            for (int row = 0; row < ps._len; ++row) {
                if (ps.isNA(row) || treatment.isNA(row)) continue;
                bldr.perRow(ps.atd(row), 1.0, actuals.atd(row), (float)treatment.atd(row));
            }
        }

        @Override
        public void reduce(AUUCImpl auuc) {
            this._bldr.reduce(auuc._bldr);
        }
    }
}

