/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Keyed;
import water.Value;
import water.fvec.Vec;
import water.util.ReflectionUtils;
import water.util.StringUtils;
import water.util.UnsafeUtils;

public final class Key<T extends Keyed>
extends Iced<Key<T>>
implements Comparable {
    public final byte[] _kb;
    final transient int _hash;
    static final byte BUILT_IN_KEY = 2;
    public static final byte JOB = 3;
    public static final byte VEC = 4;
    public static final byte CHK = 5;
    public static final byte GRP = 6;
    public static final byte HIDDEN_USER_KEY = 31;
    public static final byte USER_KEY = 32;
    private static final int KEY_HEADER_TYPE = 0;
    private static final int KEY_HEADER_CUSTOM_HOMED = 1;
    static final int VEC_PREFIX_LEN = 10;
    static final CharSequence ILLEGAL_USER_KEY_CHARS = " !@#$%^&*()+={}[]|\\;:\"'<>,/?";
    private volatile transient long _cache;
    private static final AtomicLongFieldUpdater<Key> _cacheUpdater = AtomicLongFieldUpdater.newUpdater(Key.class, "_cache");
    static final char MAGIC_CHAR = '$';
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public final boolean isVec() {
        return this._kb.length > 0 && this._kb[0] == 4;
    }

    public final boolean isChunkKey() {
        return this._kb.length > 0 && this._kb[0] == 5;
    }

    public final Key getVecKey() {
        assert (this.isChunkKey());
        return Vec.getVecKey(this);
    }

    public final T get() {
        Value val = DKV.get(this);
        return (T)(val == null ? null : (Keyed)val.get());
    }

    int D() {
        int hsz = H2O.CLOUD.size();
        if (0 == hsz) {
            return -1;
        }
        if (!this.user_allowed() && this.custom_homed()) {
            assert (this._kb[0] != 5);
            H2ONode h2o = H2ONode.intern(this._kb, 2);
            int idx = h2o.index();
            if (idx >= 0) {
                return idx;
            }
        }
        if (this._kb[0] == 5) {
            if (this._kb[1] != -1) {
                throw H2O.fail();
            }
            int cidx = UnsafeUtils.get4(this._kb, 6);
            int x = cidx / hsz;
            int z = x == 0 ? 0 : (x <= 2 ? 1 : (x <= 6 ? 2 : (x <= 14 ? 3 : 4)));
            int nidx = cidx - ((1 << z) - 1) * hsz >> z;
            return (nidx & Integer.MAX_VALUE) % hsz;
        }
        return (this._hash & Integer.MAX_VALUE) % hsz;
    }

    static int cloud(long cache) {
        return (int)(cache >>> 0) & 0xFF;
    }

    static int home(long cache) {
        return (int)(cache >>> 8) & 0xFFFF;
    }

    static long build_cache(int cidx, int home) {
        return (long)(cidx & 0xFF) | (long)(home & 0xFFFF) << 8;
    }

    int home(H2O cloud) {
        return Key.home(this.cloud_info(cloud));
    }

    public boolean home() {
        return this.home_node() == H2O.SELF;
    }

    public H2ONode home_node() {
        H2O cloud = H2O.CLOUD;
        return cloud._memary[this.home(cloud)];
    }

    private boolean set_cache(long cache) {
        long old;
        do {
            old = this._cache;
            if (!H2O.larger(Key.cloud(cache), Key.cloud(old))) {
                return false;
            }
            assert (Key.cloud(cache) != Key.cloud(old) || cache == old);
            if (old != cache) continue;
            return true;
        } while (!_cacheUpdater.compareAndSet(this, old, cache));
        return true;
    }

    long cloud_info(H2O cloud) {
        long x = this._cache;
        if (Key.cloud(x) == cloud._idx) {
            return x;
        }
        char home = (char)this.D();
        long cache = Key.build_cache(cloud._idx, home);
        this.set_cache(cache);
        return cache;
    }

    private Key(byte[] kb) {
        this._kb = kb;
        int hash = 0;
        for (byte b : kb) {
            hash += b;
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        this._hash = hash;
    }

    public static <P extends Keyed> Key<P> make(byte[] kb) {
        Key key = new Key(kb);
        Key key2 = H2O.getk(key);
        if (key2 != null) {
            return key2;
        }
        H2O cloud = H2O.CLOUD;
        key._cache = Key.build_cache(cloud._idx - '\u0001', 0);
        key.cloud_info(cloud);
        return key;
    }

    public static String rand() {
        UUID uid = UUID.randomUUID();
        long l1 = uid.getLeastSignificantBits();
        long l2 = uid.getMostSignificantBits();
        return "_" + Long.toHexString(l1) + Long.toHexString(l2);
    }

    public static <P extends Keyed> Key<P> make(String s) {
        return Key.make(Key.decodeKeyName(s != null ? s : Key.rand()));
    }

    public static <P extends Keyed> Key<P> makeSystem(String s) {
        return Key.make(s, (byte)2);
    }

    public static <P extends Keyed> Key<P> makeUserHidden(String s) {
        return Key.make(s, (byte)31);
    }

    public static <P extends Keyed> Key<P> make(H2ONode node) {
        return Key.make(Key.decodeKeyName(Key.rand()), (byte)2, false, node);
    }

    public static <P extends Keyed> Key<P> make() {
        return Key.make(Key.rand());
    }

    public static <P extends Keyed> Key<P> make(String s, byte systemType, boolean required, H2ONode home) {
        return Key.make(Key.decodeKeyName(s), systemType, required, home);
    }

    public static <P extends Keyed> Key<P> make(String s, byte systemType) {
        return Key.make(Key.decodeKeyName(s), systemType, false, null);
    }

    public static <P extends Keyed> Key<P> make(byte systemType, boolean required, H2ONode home) {
        return Key.make(Key.rand(), systemType, required, home);
    }

    private static <P extends Keyed> Key<P> make(byte[] kb, byte systemType, boolean required, H2ONode home) {
        assert (systemType < 32);
        H2ONode h2ONode = home = home != null && H2O.CLOUD.contains(home) ? home : null;
        assert (!required || home != null);
        AutoBuffer ab = new AutoBuffer();
        ab.put1(systemType);
        ab.putZ(home != null);
        if (home != null) {
            home.write(ab);
        }
        ab.put4(-1);
        ab.putA1(kb, kb.length);
        return Key.make(Arrays.copyOf(ab.buf(), ab.position()));
    }

    public void remove() {
        Keyed.remove(this);
    }

    public Futures remove(Futures fs) {
        return Keyed.remove(this, fs, true);
    }

    public boolean user_allowed() {
        return this.type() == 32;
    }

    boolean custom_homed() {
        return this._kb[1] == 1;
    }

    public int type() {
        return (this._kb[0] & 0xFF) >= 32 ? 32 : this._kb[0] & 0xFF;
    }

    public String valueClass() {
        Value v = DKV.get(this);
        if (null == v) {
            return null;
        }
        return v.className();
    }

    public String valueClassSimple() {
        String vc = this.valueClass();
        if (null == vc) {
            return null;
        }
        String[] elements = vc.split("\\.");
        return elements[elements.length - 1];
    }

    public String toString() {
        char a;
        int len = this._kb.length;
        while (--len >= 0 && (' ' <= (a = (char)this._kb[len]) && a <= '#' || '%' <= a && a <= '~')) {
        }
        if (len >= 0) {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append('$');
            for (i = 0; i <= len; ++i) {
                byte a2 = this._kb[i];
                sb.append(HEX[a2 >> 4 & 0xF]);
                sb.append(HEX[a2 >> 0 & 0xF]);
            }
            sb.append('$');
            for (i = len + 1; i < this._kb.length; ++i) {
                sb.append((char)this._kb[i]);
            }
            return sb.toString();
        }
        return new String(this._kb);
    }

    private static byte[] decodeKeyName(String what) {
        if (what == null) {
            return null;
        }
        if (what.length() == 0) {
            return null;
        }
        if (what.charAt(0) == '$') {
            int len = what.indexOf(36, 1);
            if (len < 0) {
                throw new IllegalArgumentException("No matching magic '$', key name is not legal");
            }
            String tail = what.substring(len + 1);
            byte[] res = new byte[(len - 1) / 2 + tail.length()];
            int r = 0;
            for (int i = 1; i < len; i += 2) {
                char h = what.charAt(i);
                char l = what.charAt(i + 1);
                h = (char)(h - (Character.isDigit(h) ? 48 : 87));
                l = (char)(l - (Character.isDigit(l) ? 48 : 87));
                res[r++] = (byte)(h << 4 | l);
            }
            System.arraycopy(StringUtils.bytesOf(tail), 0, res, r, tail.length());
            return res;
        }
        byte[] res = new byte[what.length()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)what.charAt(i);
        }
        return res;
    }

    public int hashCode() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Key k = (Key)o;
        if (this._hash != k._hash) {
            return false;
        }
        return Arrays.equals(k._kb, this._kb);
    }

    public int compareTo(Object o) {
        assert (o instanceof Key);
        return this.toString().compareTo(o.toString());
    }

    public static final AutoBuffer write_impl(Key k, AutoBuffer ab) {
        return ab.putA1(k._kb);
    }

    public static final Key read_impl(Key k, AutoBuffer ab) {
        return Key.make(ab.getA1());
    }

    public static final AutoBuffer writeJSON_impl(Key k, AutoBuffer ab) {
        ab.putJSONStr("name", k.toString());
        ab.put1(44);
        ab.putJSONStr("type", ReflectionUtils.findActualClassParameter(k.getClass(), 0).getSimpleName());
        return ab;
    }
}

