/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.AUUC;
import hex.ModelMetricsBinomialUplift;
import java.util.Arrays;
import water.api.API;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.EnumUtils;
import water.util.TwoDimTable;

public class ModelMetricsBinomialUpliftV3<I extends ModelMetricsBinomialUplift, S extends ModelMetricsBinomialUpliftV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="Average Treatment Effect.", direction=API.Direction.OUTPUT)
    public double ate;
    @API(help="Average Treatment Effect on the Treated.", direction=API.Direction.OUTPUT)
    public double att;
    @API(help="Average Treatment Effect on the Control.", direction=API.Direction.OUTPUT)
    public double atc;
    @API(help="The default AUUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double AUUC;
    @API(help="The default normalized AUUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double auuc_normalized;
    @API(help="The Qini value for this scoring run.", direction=API.Direction.OUTPUT)
    public double qini;
    @API(help="The class labels of the response.", direction=API.Direction.OUTPUT)
    public String[] domain;
    @API(help="The metrics for various thresholds.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 thresholds_and_metric_scores;
    @API(help="Table of all types of AUUC.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 auuc_table;
    @API(help="Table of all types of AECU values.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 aecu_table;

    @Override
    public S fillFromImpl(ModelMetricsBinomialUplift modelMetrics) {
        super.fillFromImpl(modelMetrics);
        AUUC auuc = modelMetrics._auuc;
        if (null != auuc) {
            int i;
            this.ate = modelMetrics.ate();
            this.att = modelMetrics.att();
            this.atc = modelMetrics.atc();
            this.AUUC = auuc.auuc();
            this.auuc_normalized = auuc.auucNormalized();
            this.qini = auuc.qini();
            String[] thresholds = new String[auuc._nBins];
            AUUC.AUUCType[] metrics = AUUC.AUUCType.VALUES;
            metrics = ArrayUtils.remove(metrics, Arrays.asList(metrics).indexOf((Object)AUUC.AUUCType.AUTO));
            int metricsLength = metrics.length;
            long[] n = new long[auuc._nBins];
            double[][] uplift = new double[metricsLength][];
            double[][] upliftNormalized = new double[metricsLength][];
            double[][] upliftRandom = new double[metricsLength][];
            for (int i2 = 0; i2 < auuc._nBins; ++i2) {
                thresholds[i2] = Double.toString(auuc._ths[i2]);
                n[i2] = auuc._frequencyCumsum[i2];
            }
            String[] colHeaders = new String[3 * metricsLength + 3];
            String[] types = new String[3 * metricsLength + 3];
            String[] formats = new String[3 * metricsLength + 3];
            colHeaders[0] = "thresholds";
            types[0] = "double";
            formats[0] = "%f";
            for (i = 0; i < metricsLength; ++i) {
                colHeaders[i + 1] = metrics[i].toString();
                colHeaders[i + 1 + metricsLength] = metrics[i].toString() + "_normalized";
                colHeaders[i + 1 + 2 * metricsLength] = metrics[i].toString() + "_random";
                uplift[i] = auuc.upliftByType(metrics[i]);
                upliftNormalized[i] = auuc.upliftNormalizedByType(metrics[i]);
                upliftRandom[i] = auuc.upliftRandomByType(metrics[i]);
                types[i + 1] = "double";
                formats[i + 1] = "%f";
                types[i + 1 + metricsLength] = "double";
                formats[i + 1 + metricsLength] = "%f";
                types[i + 1 + 2 * metricsLength] = "double";
                formats[i + 1 + 2 * metricsLength] = "%f";
            }
            colHeaders[i + 1 + 2 * metricsLength] = "n";
            types[i + 1 + 2 * metricsLength] = "int";
            formats[i + 1 + 2 * metricsLength] = "%d";
            colHeaders[i + 2 + 2 * metricsLength] = "idx";
            types[i + 2 + 2 * metricsLength] = "int";
            formats[i + 2 + 2 * metricsLength] = "%d";
            TwoDimTable thresholdsByMetrics = new TwoDimTable("Metrics for Thresholds", "Cumulative Uplift metrics for a given percentile", new String[auuc._nBins], colHeaders, types, formats, null);
            for (i = 0; i < auuc._nBins; ++i) {
                int j = 0;
                thresholdsByMetrics.set(i, j, Double.valueOf(thresholds[i]));
                for (j = 0; j < metricsLength; ++j) {
                    thresholdsByMetrics.set(i, 1 + j, uplift[j][i]);
                    thresholdsByMetrics.set(i, 1 + j + metricsLength, upliftNormalized[j][i]);
                    thresholdsByMetrics.set(i, 1 + j + 2 * metricsLength, upliftRandom[j][i]);
                }
                thresholdsByMetrics.set(i, 1 + j + 2 * metricsLength, n[i]);
                thresholdsByMetrics.set(i, 2 + j + 2 * metricsLength, i);
            }
            this.thresholds_and_metric_scores = new TwoDimTableV3().fillFromImpl(thresholdsByMetrics);
            String[] rowHeaders = new String[]{"AUUC value", "AUUC normalized", "AUUC random value"};
            String[] metricNames = EnumUtils.getNames(AUUC.AUUCType.class);
            colHeaders = ArrayUtils.remove(metricNames, Arrays.asList(metricNames).indexOf("AUTO"));
            types = new String[metricsLength];
            formats = new String[metricsLength];
            for (i = 0; i < metricsLength; ++i) {
                types[i] = "double";
                formats[i] = "%f";
            }
            TwoDimTable auucs = new TwoDimTable("AUUC table (number of bins: " + auuc._nBins + ")", "All types of AUUC value", rowHeaders, colHeaders, types, formats, "Uplift type");
            for (i = 0; i < metricsLength; ++i) {
                auucs.set(0, i, auuc.auucByType(metrics[i]));
                auucs.set(1, i, auuc.auucNormalizedByType(metrics[i]));
                auucs.set(2, i, auuc.auucRandomByType(metrics[i]));
            }
            this.auuc_table = new TwoDimTableV3().fillFromImpl(auucs);
            rowHeaders = new String[]{"AECU value"};
            TwoDimTable qinis = new TwoDimTable("AECU values table", "All types of AECU value", rowHeaders, colHeaders, types, formats, "Uplift type");
            for (i = 0; i < metricsLength; ++i) {
                qinis.set(0, i, auuc.aecuByType(metrics[i]));
            }
            this.aecu_table = new TwoDimTableV3().fillFromImpl(qinis);
        }
        return (S)this;
    }
}

