/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.columns;

import hex.createframe.CreateFrameColumnMaker;
import java.util.Random;
import water.fvec.NewChunk;

public class StringColumnCfcm
extends CreateFrameColumnMaker {
    private String name;
    private int len;

    public StringColumnCfcm() {
    }

    public StringColumnCfcm(String colName, int length) {
        this.name = colName;
        this.len = length;
    }

    @Override
    public void exec(int nrows, NewChunk[] ncs, Random rng) {
        byte[] buf = new byte[this.len];
        for (int row = 0; row < nrows; ++row) {
            for (int i = 0; i < this.len; ++i) {
                buf[i] = (byte)(65 + rng.nextInt(25));
            }
            ncs[this.index].addStr(new String(buf));
        }
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.name};
    }

    @Override
    public byte[] columnTypes() {
        return new byte[]{2};
    }

    @Override
    public float byteSizePerRow() {
        return this.len;
    }

    @Override
    public int workAmount() {
        return 60 + this.len * 50;
    }
}

