/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.Value;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.logging.Logger;
import water.logging.LoggerFactory;

public class Scope {
    private static final Logger log = LoggerFactory.getLogger(Scope.class);
    private static final ThreadLocal<Scope> _scope = new ThreadLocal<Scope>(){

        @Override
        protected Scope initialValue() {
            return new Scope();
        }
    };
    private final Stack<Level> _levels = new Stack();

    public static Scope current() {
        return _scope.get();
    }

    public static int nLevel() {
        Scope scope = Scope.current();
        return scope._levels.size();
    }

    public static void reset() {
        Scope scope = _scope.get();
        scope._levels.clear();
    }

    public static void enter() {
        Level outer;
        Scope scope = _scope.get();
        Level level = new Level();
        Level level2 = outer = scope._levels.empty() ? null : scope._levels.peek();
        if (outer != null) {
            level._protectedKeys.addAll(outer._protectedKeys);
        }
        scope._levels.push(level);
    }

    public static Key[] exit(Key ... keep) {
        Scope scope = _scope.get();
        assert (!scope._levels.empty()) : "Scope in inconsistent state: Scope.exit() called without a matching Scope.enter()";
        HashSet<Key> keepKeys = new HashSet<Key>();
        if (keep != null) {
            for (Key k : keep) {
                if (k == null) continue;
                keepKeys.add(k);
            }
        }
        Level exitingLevel = scope._levels.pop();
        keepKeys.addAll(exitingLevel._protectedKeys);
        Object[] arrkeep = keepKeys.toArray(new Key[0]);
        Arrays.sort(arrkeep);
        Futures fs = new Futures();
        HashMap bulkRemovals = new HashMap();
        for (Key key : exitingLevel._keys) {
            boolean cascade;
            boolean remove = arrkeep.length == 0 || Arrays.binarySearch(arrkeep, key) < 0;
            if (!remove) continue;
            Value v = DKV.get(key);
            boolean bl = cascade = v != null && !v.isFrame();
            if (v != null && v.isVec() && exitingLevel._trackingInfo.containsKey(key)) {
                int nchunks = exitingLevel._trackingInfo.get((Object)key)._nchunks;
                if (nchunks < 0) {
                    Keyed.remove(key, fs, cascade);
                    continue;
                }
                if (!bulkRemovals.containsKey(nchunks)) {
                    bulkRemovals.put(nchunks, new ArrayList());
                }
                ((List)bulkRemovals.get(nchunks)).add(key);
                continue;
            }
            Keyed.remove(key, fs, cascade);
        }
        for (Map.Entry entry : bulkRemovals.entrySet()) {
            Vec.bulk_remove(((List)entry.getValue()).toArray(new Key[0]), (Integer)entry.getKey());
        }
        fs.blockForPending();
        exitingLevel.clear();
        return keep;
    }

    public static boolean isActive() {
        return !Scope._scope.get()._levels.empty();
    }

    private static Level lget() {
        Scope scope = _scope.get();
        return scope._levels.empty() ? null : scope._levels.peek();
    }

    static void track_internal(Key k) {
        if (k.user_allowed() || !k.isVec()) {
            return;
        }
        Scope scope = _scope.get();
        if (scope._levels.empty()) {
            return;
        }
        Scope.track_impl(scope._levels.peek(), k);
    }

    public static <T extends Keyed<T>> T track_generic(T keyed) {
        if (keyed == null) {
            return null;
        }
        Level level = Scope.lget();
        Scope.track_impl(level, keyed._key);
        return keyed;
    }

    public static Vec track(Vec vec) {
        if (vec == null) {
            return vec;
        }
        Level level = Scope.lget();
        if (level == null) {
            return vec;
        }
        Scope.track_impl(level, vec._key);
        if (!(vec instanceof FileVec)) {
            TrackingInfo vecInfo = new TrackingInfo();
            vecInfo._nchunks = vec.nChunks();
            level._trackingInfo.put(vec._key, vecInfo);
        }
        return vec;
    }

    public static Frame track(Frame ... frames) {
        if (frames.length == 0) {
            return null;
        }
        Level level = Scope.lget();
        if (level == null) {
            return frames[0];
        }
        for (Frame fr : frames) {
            if (fr == null) continue;
            Scope.track_impl(level, fr._key);
            TrackingInfo vecInfo = new TrackingInfo();
            vecInfo._source = Objects.toString(fr._key);
            for (Key<Vec> vkey : fr.keys()) {
                Vec vec;
                Scope.track_impl(level, vkey);
                if (vecInfo._nchunks < 0 && (vec = vkey.get()) != null) {
                    vecInfo._nchunks = vec.nChunks();
                }
                if (vecInfo._nchunks <= 0) continue;
                level._trackingInfo.put(vkey, vecInfo);
            }
        }
        return frames[0];
    }

    private static void track_impl(Level level, Key key) {
        if (key == null) {
            return;
        }
        if (level == null) {
            return;
        }
        level._keys.add(key);
    }

    public static <K extends Key> void untrack(K ... keys) {
        if (keys.length == 0) {
            return;
        }
        Level level = Scope.lget();
        if (level == null) {
            return;
        }
        Set<Key> xkeys = level._keys;
        for (K key : keys) {
            xkeys.remove(key);
        }
    }

    public static <K extends Key> void untrack(Iterable<K> keys) {
        Level level = Scope.lget();
        if (level == null) {
            return;
        }
        Set<Key> xkeys = level._keys;
        for (Key key : keys) {
            xkeys.remove(key);
        }
    }

    public static Frame untrack(Frame ... frames) {
        if (frames.length == 0) {
            return null;
        }
        Level level = Scope.lget();
        if (level == null) {
            return frames[0];
        }
        Set<Key> xkeys = level._keys;
        for (Frame fr : frames) {
            xkeys.remove(fr._key);
            xkeys.removeAll(Arrays.asList(fr.keys()));
        }
        return frames[0];
    }

    public static Frame protect(Frame ... frames) {
        if (frames.length == 0) {
            return null;
        }
        Level level = Scope.lget();
        for (Frame fr : frames) {
            if (fr == null) continue;
            Scope.protect_impl(level, fr._key);
            for (Vec vec : fr.vecs()) {
                Scope.protect_impl(level, vec._key);
            }
        }
        return frames[0];
    }

    private static void protect_impl(Level level, Key key) {
        if (key == null) {
            return;
        }
        if (level == null) {
            return;
        }
        level._protectedKeys.add(key);
    }

    public static Safe safe(Frame ... protectedFrames) {
        Safe scope = new Safe();
        Scope.protect(protectedFrames);
        return scope;
    }

    List<Level> levels() {
        return Collections.unmodifiableList(this._levels.stream().map(ROLevel::new).collect(Collectors.toList()));
    }

    static class TrackingInfo {
        int _nchunks = -1;
        String _source;

        TrackingInfo() {
        }
    }

    private static class ROLevel
    extends Level {
        public ROLevel(Level level) {
            super(Collections.unmodifiableSet(level._keys), Collections.unmodifiableSet(level._protectedKeys), Collections.unmodifiableMap(level._trackingInfo));
        }
    }

    static class Level {
        final Set<Key> _keys;
        final Set<Key> _protectedKeys;
        final Map<Key, TrackingInfo> _trackingInfo;

        Level() {
            this._keys = new HashSet<Key>();
            this._protectedKeys = new HashSet<Key>();
            this._trackingInfo = new HashMap<Key, TrackingInfo>();
        }

        Level(Set<Key> keys, Set<Key> protectedKeys, Map<Key, TrackingInfo> trackingInfo) {
            this._keys = keys;
            this._protectedKeys = protectedKeys;
            this._trackingInfo = trackingInfo;
        }

        void clear() {
            this._keys.clear();
            this._protectedKeys.clear();
            this._trackingInfo.clear();
        }
    }

    public static class Safe
    implements AutoCloseable {
        private Safe() {
            Scope.enter();
        }

        @Override
        public void close() {
            Scope.exit(new Key[0]);
        }
    }
}

