/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.DKVManager;
import water.Futures;
import water.Job;
import water.Key;
import water.api.Handler;
import water.api.RapidsHandler;
import water.api.schemas3.KeyV3;
import water.api.schemas3.RemoveAllV3;
import water.util.Log;

public class RemoveAllHandler
extends Handler {
    public RemoveAllV3 remove(int version, RemoveAllV3 u) {
        Futures fs = new Futures();
        for (Job j : Job.jobs()) {
            j.stop_requested();
            j.remove(fs);
        }
        if (RapidsHandler.SESSIONS != null) {
            for (String k : RapidsHandler.SESSIONS.keySet()) {
                RapidsHandler.SESSIONS.get(k).endQuietly(null);
            }
            RapidsHandler.SESSIONS.clear();
        }
        fs.blockForPending();
        if (u.retained_keys != null && u.retained_keys.length != 0) {
            this.retainKeys(u.retained_keys);
        } else {
            this.clearAll();
        }
        Log.info("Finished removing objects");
        return u;
    }

    private void clearAll() {
        Log.info("Removing all objects");
        DKVManager.clear();
    }

    private void retainKeys(KeyV3[] retained_keys) {
        Key[] retainedKeys;
        Log.info(String.format("Removing all objects, except for %d provided key(s)", retained_keys.length));
        if (retained_keys == null) {
            retainedKeys = new Key[]{};
        } else {
            retainedKeys = new Key[retained_keys.length];
            for (int i = 0; i < retainedKeys.length; ++i) {
                if (retained_keys[i] == null) {
                    throw new IllegalArgumentException("An attempt to retain a 'null' key detected. Cleaning operation aborted.");
                }
                retainedKeys[i] = retained_keys[i].key();
            }
        }
        DKVManager.retain(retainedKeys);
    }
}

