/*
 * Decompiled with CFR 0.152.
 */
package au.com.acegi.xmlformat;

import au.com.acegi.xmlformat.AbstractXmlPlugin;
import au.com.acegi.xmlformat.FormatUtil;
import au.com.acegi.xmlformat.XmlOutputFormat;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.dom4j.DocumentException;

@Mojo(name="xml-check", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public final class XmlCheckPlugin
extends AbstractXmlPlugin {
    @Override
    protected boolean processFile(File input, XmlOutputFormat fmt) throws DocumentException, IOException {
        boolean needsFormatting = FormatUtil.needsFormatting(input, fmt);
        Log log = this.getLog();
        if (needsFormatting && log.isErrorEnabled()) {
            log.error((CharSequence)("[xml-check] Needs formatting:" + input));
        } else if (log.isDebugEnabled()) {
            log.debug((CharSequence)("[xml-check] Correctly formatted: " + input));
        }
        return needsFormatting;
    }

    @Override
    protected void afterAllProcessed(boolean neededFormatting) throws MojoExecutionException {
        if (neededFormatting) {
            throw new MojoExecutionException("[xml-check] At least one XML file needs formatting, see the error logs above)");
        }
    }
}

