/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.OutputAccessor;
import biz.paluch.logging.gelf.intern.ReusableGzipOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class PoolingGelfMessage
extends GelfMessage {
    private static final ThreadLocal<byte[]> BYTE_ARRAY_POOL = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[16384];
        }
    };
    private static final ThreadLocal<ReusableGzipOutputStream> STREAM_POOL = new ThreadLocal<ReusableGzipOutputStream>(){

        @Override
        protected ReusableGzipOutputStream initialValue() {
            try {
                return new ReusableGzipOutputStream(OutputAccessor.pooledStream());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private static final ThreadLocal<ByteBuffer[]> SINGLE_BUFFER = new ThreadLocal<ByteBuffer[]>(){

        @Override
        protected ByteBuffer[] initialValue() {
            return new ByteBuffer[1];
        }
    };

    public PoolingGelfMessage() {
    }

    public PoolingGelfMessage(String shortMessage, String fullMessage, long timestamp, String level) {
        super(shortMessage, fullMessage, timestamp, level);
    }

    @Override
    public ByteBuffer[] toUDPBuffers(ByteBuffer buffer, ByteBuffer tempBuffer) {
        try {
            this.toJson(buffer, "_");
            OutputAccessor.asStream(tempBuffer);
            ReusableGzipOutputStream gz = STREAM_POOL.get();
            gz.reset();
            gz.writeHeader();
            buffer.mark();
            this.gzip(buffer, gz);
            gz.finish();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (tempBuffer.position() > this.getMaximumMessageSize()) {
            int diagrams_length = tempBuffer.position() / this.getMaximumMessageSize();
            if (tempBuffer.position() % this.getMaximumMessageSize() != 0) {
                ++diagrams_length;
            }
            buffer.clear();
            return this.sliceDatagrams((ByteBuffer)tempBuffer.flip(), diagrams_length, buffer);
        }
        ByteBuffer[] byteBuffers = SINGLE_BUFFER.get();
        byteBuffers[0] = (ByteBuffer)tempBuffer.flip();
        return byteBuffers;
    }

    private void gzip(ByteBuffer source, ReusableGzipOutputStream gz) throws IOException {
        int size = source.position();
        if (source.isDirect()) {
            int read = 0;
            source.position(0);
            byte[] bytes = BYTE_ARRAY_POOL.get();
            while (size > read) {
                if (size - read > bytes.length) {
                    read += bytes.length;
                    source.get(bytes);
                    gz.write(bytes);
                    continue;
                }
                int remain = size - read;
                read += remain;
                source.get(bytes, 0, remain);
                gz.write(bytes, 0, remain);
            }
        } else {
            gz.write(source.array(), source.arrayOffset(), source.position());
        }
    }
}

