/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ConfigurationSupport;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.intern.MessagePostprocessingErrorReporter;
import biz.paluch.logging.gelf.log4j.Log4jLogEvent;
import java.util.Collections;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class GelfLogAppender
extends AppenderSkeleton
implements ErrorReporter {
    protected GelfSender gelfSender;
    protected MdcGelfMessageAssembler gelfMessageAssembler;
    private final ErrorReporter errorReporter = new MessagePostprocessingErrorReporter(this);

    public GelfLogAppender() {
        RuntimeContainer.initialize(this.errorReporter);
        this.gelfMessageAssembler = new MdcGelfMessageAssembler();
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(LogMessageField.NamedLogField.Time, LogMessageField.NamedLogField.Severity, LogMessageField.NamedLogField.ThreadName, LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceLineNumber, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.LoggerName, LogMessageField.NamedLogField.NDC, LogMessageField.NamedLogField.Server));
    }

    protected void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null);
                return;
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e);
        }
    }

    protected GelfSender createGelfSender() {
        return GelfSenderFactory.createSender(this.gelfMessageAssembler, this.errorReporter, Collections.EMPTY_MAP);
    }

    @Override
    public void reportError(String message, Exception exception) {
        this.errorHandler.error(message, exception, 0);
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        if (null == this.gelfSender) {
            this.gelfSender = this.createGelfSender();
        }
    }

    public void close() {
        if (null != this.gelfSender) {
            Closer.close(this.gelfSender);
            this.gelfSender = null;
        }
    }

    protected GelfMessage createGelfMessage(LoggingEvent loggingEvent) {
        return this.gelfMessageAssembler.createGelfMessage(new Log4jLogEvent(loggingEvent));
    }

    public void setAdditionalFields(String spec) {
        ConfigurationSupport.setAdditionalFields(spec, this.gelfMessageAssembler);
    }

    public void setAdditionalFieldTypes(String spec) {
        ConfigurationSupport.setAdditionalFieldTypes(spec, this.gelfMessageAssembler);
    }

    public void setMdcFields(String spec) {
        ConfigurationSupport.setMdcFields(spec, this.gelfMessageAssembler);
    }

    public void setDynamicMdcFields(String spec) {
        ConfigurationSupport.setDynamicMdcFields(spec, this.gelfMessageAssembler);
    }

    public String getGraylogHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setGraylogHost(String graylogHost) {
        this.gelfMessageAssembler.setHost(graylogHost);
    }

    public int getGraylogPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setGraylogPort(int graylogPort) {
        this.gelfMessageAssembler.setPort(graylogPort);
    }

    public String getHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setHost(String host) {
        this.gelfMessageAssembler.setHost(host);
    }

    public int getPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setPort(int port) {
        this.gelfMessageAssembler.setPort(port);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public String getExtractStackTrace() {
        return this.gelfMessageAssembler.getExtractStackTrace();
    }

    public void setExtractStackTrace(String extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public boolean isMdcProfiling() {
        return this.gelfMessageAssembler.isMdcProfiling();
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.gelfMessageAssembler.setMdcProfiling(mdcProfiling);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public int getMaximumMessageSize() {
        return this.gelfMessageAssembler.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.gelfMessageAssembler.setMaximumMessageSize(maximumMessageSize);
    }

    public boolean isIncludeFullMdc() {
        return this.gelfMessageAssembler.isIncludeFullMdc();
    }

    public void setIncludeFullMdc(boolean includeFullMdc) {
        this.gelfMessageAssembler.setIncludeFullMdc(includeFullMdc);
    }

    public String getVersion() {
        return this.gelfMessageAssembler.getVersion();
    }

    public void setVersion(String version) {
        this.gelfMessageAssembler.setVersion(version);
    }
}

