/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.log4j.Log4jVersionChecker;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class Log4jLogEvent
implements LogEvent {
    private LoggingEvent loggingEvent;

    public Log4jLogEvent(LoggingEvent loggingEvent) {
        this.loggingEvent = loggingEvent;
    }

    @Override
    public String getMessage() {
        return this.loggingEvent.getRenderedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Throwable getThrowable() {
        ThrowableInformation ti = this.loggingEvent.getThrowableInformation();
        if (ti != null) {
            return ti.getThrowable();
        }
        return null;
    }

    @Override
    public long getLogTimestamp() {
        return Log4jVersionChecker.getTimeStamp(this.loggingEvent);
    }

    @Override
    public String getSyslogLevel() {
        return "" + this.levelToSyslogLevel(this.loggingEvent.getLevel());
    }

    private int levelToSyslogLevel(Level level) {
        switch (level.toInt()) {
            case 50000: {
                return 2;
            }
            case 40000: {
                return 3;
            }
            case 30000: {
                return 4;
            }
            case 20000: {
                return 6;
            }
        }
        return 7;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof LogMessageField) {
            return new Values(field.getName(), this.getValue((LogMessageField)field));
        }
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getValue((MdcMessageField)field));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case Severity: {
                return this.loggingEvent.getLevel().toString();
            }
            case ThreadName: {
                return this.loggingEvent.getThreadName();
            }
            case SourceClassName: {
                return this.loggingEvent.getLocationInformation().getClassName();
            }
            case SourceMethodName: {
                return this.loggingEvent.getLocationInformation().getMethodName();
            }
            case SourceSimpleClassName: {
                return GelfUtil.getSimpleClassName(this.loggingEvent.getLocationInformation().getClassName());
            }
            case LoggerName: {
                return this.loggingEvent.getLoggerName();
            }
            case NDC: {
                String ndc = NDC.get();
                if (ndc != null && !"".equals(ndc)) {
                    return ndc;
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    private String getValue(MdcMessageField field) {
        return this.getMdcValue(field.getMdcName());
    }

    @Override
    public String getMdcValue(String mdcName) {
        Object value = MDC.get((String)mdcName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = this.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcName == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        HashSet<String> mdcNames = new HashSet<String>();
        Hashtable context = MDC.getContext();
        if (context != null) {
            mdcNames.addAll(context.keySet());
        }
        return mdcNames;
    }

    private Set<String> getMatchingMdcNames(DynamicMdcMessageField field, Set<String> mdcNames) {
        HashSet<String> matchingMdcNames = new HashSet<String>();
        for (String mdcName : mdcNames) {
            if (!field.getPattern().matcher(mdcName).matches()) continue;
            matchingMdcNames.add(mdcName);
        }
        return matchingMdcNames;
    }

    @Override
    public Set<String> getMdcNames() {
        return this.getAllMdcNames();
    }
}

