/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor;

import br.com.caelum.vraptor.core.StaticContentHandler;
import br.com.caelum.vraptor.events.RequestStarted;
import br.com.caelum.vraptor.events.VRaptorInitialized;
import br.com.caelum.vraptor.http.EncodingHandler;
import br.com.caelum.vraptor.interceptor.ApplicationLogicException;
import br.com.caelum.vraptor.ioc.RequestStartedFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIRequestFactories;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="vraptor", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.FORWARD, DispatcherType.REQUEST}, asyncSupported=true)
public class VRaptor
implements Filter {
    public static final String VERSION = "4.2.0.Final";
    private final Logger logger = LoggerFactory.getLogger(VRaptor.class);
    private ServletContext servletContext;
    @Inject
    private StaticContentHandler staticHandler;
    @Inject
    private EncodingHandler encodingHandler;
    @Inject
    private Event<VRaptorInitialized> initializedEvent;
    @Inject
    private Event<RequestStarted> requestStartedEvent;
    @Inject
    private RequestStartedFactory requestStartedFactory;
    @Inject
    private CDIRequestFactories cdiRequestFactories;

    public void init(FilterConfig cfg) throws ServletException {
        this.servletContext = cfg.getServletContext();
        this.validateJavaEE7Environment();
        this.validateIfCdiIsFound();
        this.warnIfBeansXmlIsNotFound();
        this.initializedEvent.fire((Object)new VRaptorInitialized(this.servletContext));
        this.logger.info("VRaptor {} successfuly initialized", (Object)VERSION);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.validateServletEnvironment(req, res);
        HttpServletRequest baseRequest = (HttpServletRequest)req;
        HttpServletResponse baseResponse = (HttpServletResponse)res;
        if (this.isWebsocketRequest(baseRequest)) {
            chain.doFilter(req, res);
            return;
        }
        if (this.staticHandler.requestingStaticFile(baseRequest)) {
            this.staticHandler.deferProcessingToContainer(chain, baseRequest, baseResponse);
        } else {
            this.logger.trace("VRaptor received a new request {}", (Object)req);
            try {
                this.encodingHandler.setEncoding(baseRequest, baseResponse);
                RequestStarted requestStarted = this.requestStartedFactory.createEvent(baseRequest, baseResponse, chain);
                this.cdiRequestFactories.setRequest(requestStarted);
                this.requestStartedEvent.fire((Object)requestStarted);
            }
            catch (ApplicationLogicException e) {
                throw new ServletException(e.getMessage(), e.getCause());
            }
            this.logger.debug("VRaptor ended the request");
        }
    }

    public void destroy() {
        this.servletContext = null;
    }

    private void validateServletEnvironment(ServletRequest req, ServletResponse res) throws ServletException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("VRaptor must be run inside a Servlet environment. Portlets and others aren't supported.");
        }
    }

    private void warnIfBeansXmlIsNotFound() throws ServletException {
        URL webInfFile = this.getResource("/WEB-INF/beans.xml");
        URL metaInfFile = this.getResource("/WEB-INF/classes/META-INF/beans.xml");
        if (webInfFile == null && metaInfFile == null) {
            this.logger.warn("A beans.xml isn't found. Check if is properly located at /WEB-INF/beans.xml or /WEB-INF/classes/META-INF/beans.xml");
        }
    }

    private URL getResource(String path) throws ServletException {
        try {
            return this.servletContext.getResource(path);
        }
        catch (MalformedURLException e) {
            this.logger.error("Something went wrong when trying to locate a beans.xml file", (Throwable)e);
            return null;
        }
    }

    private void validateJavaEE7Environment() throws ServletException {
        try {
            this.servletContext.getJspConfigDescriptor();
            Interceptor.Priority.class.toString();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new ServletException("VRaptor only runs under Java EE 7 environment or Servlet Containers that supports Servlets 3 with CDI 1.1 jars.");
        }
    }

    private void validateIfCdiIsFound() throws ServletException {
        if (this.staticHandler == null) {
            throw new ServletException("Dependencies were not set. Do you have a Weld/CDI listener setup in your web.xml?");
        }
    }

    private boolean isWebsocketRequest(HttpServletRequest request) {
        String upgradeHeader = request.getHeader("Upgrade");
        return upgradeHeader != null && upgradeHeader.toLowerCase().contains("websocket");
    }
}

