/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.cache;

import br.com.caelum.vraptor.cache.CacheException;
import br.com.caelum.vraptor.cache.CacheStore;
import br.com.caelum.vraptor.cache.DefaultCacheStore;
import br.com.caelum.vraptor.cache.LRU;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@Dependent
public class CacheStoreFactory {
    @Produces
    @Default
    public <K, V> CacheStore<K, V> buildDefaultCache() {
        return new DefaultCacheStore();
    }

    @Produces
    @LRU
    public <K, V> CacheStore<K, V> buildLRUCache(InjectionPoint ip) {
        int capacity = ((LRU)ip.getAnnotated().getAnnotation(LRU.class)).capacity();
        return this.createCacheWrapper(capacity);
    }

    public <V, K> CacheStore<K, V> createCacheWrapper(int capacity) {
        Cache guavaCache = CacheBuilder.newBuilder().maximumSize((long)capacity).build();
        return new GuavaCacheWrapper(guavaCache);
    }

    public static class GuavaCacheWrapper<K, V>
    implements CacheStore<K, V> {
        private Cache<K, V> guavaCache;

        public GuavaCacheWrapper(Cache<K, V> guavaCache) {
            this.guavaCache = guavaCache;
        }

        @Override
        public V write(K key, V value) {
            this.guavaCache.put(key, value);
            return value;
        }

        @Override
        public V fetch(K key) {
            return (V)this.guavaCache.getIfPresent(key);
        }

        @Override
        public V fetch(K key, Supplier<V> valueProvider) {
            final Supplier<V> userSuplier = valueProvider;
            try {
                return (V)this.guavaCache.get(key, new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        return userSuplier.get();
                    }
                });
            }
            catch (ExecutionException e) {
                throw new CacheException("Error while trying to fetch key: " + key, e);
            }
        }
    }
}

