/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;

@Convert(value=Boolean.class)
@ApplicationScoped
@Alternative
@Priority(value=1000)
public class BooleanConverter
implements Converter<Boolean> {
    private static final String INVALID_MESSAGE_KEY = "is_not_a_valid_boolean";
    private static final Set<String> IS_TRUE = Sets.newHashSet((Object[])new String[]{"TRUE", "1", "YES", "Y", "ON"});
    private static final Set<String> IS_FALSE = Sets.newHashSet((Object[])new String[]{"FALSE", "0", "NO", "N", "OFF"});

    @Override
    public Boolean convert(String value, Class<? extends Boolean> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (BooleanConverter.matches(IS_TRUE, value = value.toUpperCase())) {
            return true;
        }
        if (BooleanConverter.matches(IS_FALSE, value)) {
            return false;
        }
        throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
    }

    private static boolean matches(Set<String> words, String value) {
        return words.contains(value);
    }
}

