/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;

@Convert(value=Byte.class)
@ApplicationScoped
@Alternative
@Priority(value=1000)
public class ByteConverter
implements Converter<Byte> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_number";

    @Override
    public Byte convert(String value, Class<? extends Byte> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }
}

