/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Convert(value=Calendar.class)
@Alternative
@Priority(value=1000)
public class CalendarConverter
implements Converter<Calendar> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_date";
    private final Locale locale;

    protected CalendarConverter() {
        this(null);
    }

    @Inject
    public CalendarConverter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Calendar convert(String value, Class<? extends Calendar> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            Date date = this.getDateFormat().parse(value);
            Calendar calendar = Calendar.getInstance(this.locale);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    protected DateFormat getDateFormat() {
        return DateFormat.getDateInstance(3, this.locale);
    }
}

