/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;

@Convert(value=Character.class)
@ApplicationScoped
@Alternative
@Priority(value=1000)
public class CharacterConverter
implements Converter<Character> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_character";

    @Override
    public Character convert(String value, Class<? extends Character> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (value.length() != 1) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
        return Character.valueOf(value.charAt(0));
    }
}

