/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;

@Convert(value=Date.class)
@Alternative
@Priority(value=1000)
public class DateConverter
implements Converter<Date> {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_date";
    private final Locale locale;

    protected DateConverter() {
        this(null);
    }

    @Inject
    public DateConverter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Date convert(String value, Class<? extends Date> type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return this.getDateFormat().parse(value);
        }
        catch (ParseException pe) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    protected DateFormat getDateFormat() {
        return DateFormat.getDateInstance(3, this.locale);
    }
}

