/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.converter.ConversionException;
import br.com.caelum.vraptor.converter.ConversionMessage;
import br.com.caelum.vraptor.converter.Converter;
import com.google.common.base.Strings;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;

@Convert(value=Enum.class)
@ApplicationScoped
@Alternative
@Priority(value=1000)
public class EnumConverter
implements Converter {
    public static final String INVALID_MESSAGE_KEY = "is_not_a_valid_enum_value";

    public Object convert(String value, Class type) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (Character.isDigit(value.charAt(0))) {
            return this.resolveByOrdinal(value, type);
        }
        return this.resolveByName(value, type);
    }

    private Object resolveByName(String value, Class enumType) {
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }

    private Object resolveByOrdinal(String value, Class enumType) {
        try {
            int ordinal = Integer.parseInt(value);
            if (ordinal >= enumType.getEnumConstants().length) {
                throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
            }
            return enumType.getEnumConstants()[ordinal];
        }
        catch (NumberFormatException e) {
            throw new ConversionException(new ConversionMessage(INVALID_MESSAGE_KEY, value));
        }
    }
}

