/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.TwoWayConverter;
import br.com.caelum.vraptor.cache.CacheStore;
import br.com.caelum.vraptor.cache.LRU;
import br.com.caelum.vraptor.converter.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.Container;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultConverters
implements Converters {
    private final Logger logger = LoggerFactory.getLogger(DefaultConverters.class);
    private final List<Class<? extends Converter<?>>> classes = new LinkedList();
    private final CacheStore<Class<?>, Class<? extends Converter<?>>> cache;
    private final Container container;

    protected DefaultConverters() {
        this(null, null);
    }

    @Inject
    public DefaultConverters(Container container, @LRU CacheStore<Class<?>, Class<? extends Converter<?>>> cache) {
        this.container = container;
        this.cache = cache;
        this.logger.info("Registering bundled converters");
    }

    @Override
    public void register(Class<? extends Converter<?>> converterClass) {
        Convert type = converterClass.getAnnotation(Convert.class);
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"The converter type %s should have the Convert annotation", (Object[])new Object[]{converterClass.getName()});
        Class<Converter<?>> currentConverter = this.findConverterType(type.value());
        if (!currentConverter.equals(NullConverter.class)) {
            int priority = this.getConverterPriority(converterClass);
            int priorityCurrent = this.getConverterPriority(currentConverter);
            Convert currentType = currentConverter.getAnnotation(Convert.class);
            Preconditions.checkState((priority != priorityCurrent || !type.value().equals(currentType.value()) ? 1 : 0) != 0, (String)"Converter %s have same priority than %s", (Object[])new Object[]{converterClass, currentConverter});
            if (priority > priorityCurrent) {
                this.logger.debug("Overriding converter {} with {} because have more priority", currentConverter, converterClass);
                this.classes.remove(currentConverter);
                this.classes.add(converterClass);
            } else {
                this.logger.debug("Converter {} not registered because have less priority than {}", converterClass, currentConverter);
            }
        }
        this.logger.debug("adding converter {} to {}", converterClass, type.value());
        this.classes.add(converterClass);
    }

    private int getConverterPriority(Class<? extends Converter<?>> converter) {
        Priority priority = converter.getAnnotation(Priority.class);
        return priority == null ? 0 : priority.value();
    }

    @Override
    public <T> Converter<T> to(Class<T> clazz) {
        Class<Converter<?>> converterType = this.findConverterTypeFromCache(clazz);
        Preconditions.checkState((!converterType.equals(NullConverter.class) ? 1 : 0) != 0, (String)"Unable to find converter for %s", (Object[])new Object[]{clazz.getName()});
        this.logger.debug("found converter {} to {}", (Object)converterType.getName(), (Object)clazz.getName());
        return this.container.instanceFor(converterType);
    }

    private Class<? extends Converter<?>> findConverterTypeFromCache(final Class<?> clazz) {
        return this.cache.fetch(clazz, new Supplier<Class<? extends Converter<?>>>(){

            public Class<? extends Converter<?>> get() {
                return DefaultConverters.this.findConverterType(clazz);
            }
        });
    }

    private Class<? extends Converter<?>> findConverterType(Class<?> clazz) {
        Class<Converter<?>> found = null;
        Class<?> foundType = null;
        for (Class<Converter<?>> current : this.classes) {
            Class<?> boundType = current.getAnnotation(Convert.class).value();
            if (boundType.equals(clazz)) {
                return current;
            }
            if (!boundType.isAssignableFrom(clazz) || foundType != null && !foundType.isAssignableFrom(boundType)) continue;
            foundType = boundType;
            found = current;
        }
        if (found != null) {
            return found;
        }
        this.logger.debug("Unable to find a converter for {}. Returning NullConverter.", clazz);
        return NullConverter.class;
    }

    @Override
    public boolean existsFor(Class<?> type) {
        return !this.findConverterTypeFromCache(type).equals(NullConverter.class);
    }

    @Override
    public boolean existsTwoWayFor(Class<?> type) {
        return TwoWayConverter.class.isAssignableFrom(this.findConverterTypeFromCache(type));
    }

    @Override
    public TwoWayConverter<?> twoWayConverterFor(Class<?> type) {
        Preconditions.checkState((boolean)this.existsTwoWayFor(type), (String)"Unable to find two way converter for %s", (Object[])new Object[]{type.getName()});
        return (TwoWayConverter)this.container.instanceFor(this.findConverterTypeFromCache(type));
    }

    private static interface NullConverter
    extends Converter<Object> {
    }
}

