/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.cache.CacheStore;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorHandlerFactory;
import br.com.caelum.vraptor.core.ToInstantiateInterceptorHandler;
import br.com.caelum.vraptor.interceptor.AspectStyleInterceptorHandler;
import br.com.caelum.vraptor.interceptor.CustomAcceptsExecutor;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.InterceptorAcceptsExecutor;
import br.com.caelum.vraptor.interceptor.InterceptorExecutor;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.observer.ExecuteMethodExceptionHandler;
import com.google.common.base.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultInterceptorHandlerFactory
implements InterceptorHandlerFactory {
    private final Container container;
    private final CacheStore<Class<?>, InterceptorHandler> cachedHandlers;
    private final StepInvoker stepInvoker;
    private final InterceptorAcceptsExecutor acceptsExecutor;
    private final CustomAcceptsExecutor customAcceptsExecutor;
    private final InterceptorExecutor interceptorExecutor;
    private final ExecuteMethodExceptionHandler executeMethodExceptionHandler;

    protected DefaultInterceptorHandlerFactory() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public DefaultInterceptorHandlerFactory(Container container, StepInvoker stepInvoker, CacheStore<Class<?>, InterceptorHandler> cachedHandlers, InterceptorAcceptsExecutor acceptsExecutor, CustomAcceptsExecutor customAcceptsExecutor, InterceptorExecutor interceptorExecutor, ExecuteMethodExceptionHandler executeMethodExceptionHandler) {
        this.container = container;
        this.stepInvoker = stepInvoker;
        this.cachedHandlers = cachedHandlers;
        this.acceptsExecutor = acceptsExecutor;
        this.customAcceptsExecutor = customAcceptsExecutor;
        this.interceptorExecutor = interceptorExecutor;
        this.executeMethodExceptionHandler = executeMethodExceptionHandler;
    }

    @Override
    public InterceptorHandler handlerFor(final Class<?> type) {
        return this.cachedHandlers.fetch(type, new Supplier<InterceptorHandler>(){

            public InterceptorHandler get() {
                if (type.isAnnotationPresent(Intercepts.class) && !Interceptor.class.isAssignableFrom(type)) {
                    return new AspectStyleInterceptorHandler(type, DefaultInterceptorHandlerFactory.this.stepInvoker, DefaultInterceptorHandlerFactory.this.container, DefaultInterceptorHandlerFactory.this.customAcceptsExecutor, DefaultInterceptorHandlerFactory.this.acceptsExecutor, DefaultInterceptorHandlerFactory.this.interceptorExecutor);
                }
                return new ToInstantiateInterceptorHandler(DefaultInterceptorHandlerFactory.this.container, type, DefaultInterceptorHandlerFactory.this.executeMethodExceptionHandler);
            }
        });
    }
}

