/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.AbstractResult;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.validator.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultResult
extends AbstractResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResult.class);
    private final HttpServletRequest request;
    private final Container container;
    private final ExceptionMapper exceptions;
    private final TypeNameExtractor extractor;
    private final Messages messages;
    private Map<String, Object> includedAttributes;
    private boolean responseCommitted;

    protected DefaultResult() {
        this(null, null, null, null, null);
    }

    @Inject
    public DefaultResult(HttpServletRequest request, Container container, ExceptionMapper exceptions, TypeNameExtractor extractor, Messages messages) {
        this.request = request;
        this.container = container;
        this.extractor = extractor;
        this.includedAttributes = new HashMap<String, Object>();
        this.exceptions = exceptions;
        this.messages = messages;
    }

    @Override
    public <T extends View> T use(Class<T> view) {
        this.messages.assertAbsenceOfErrors();
        this.responseCommitted = true;
        return (T)((View)this.container.instanceFor(view));
    }

    @Override
    public Result on(Class<? extends Exception> exception) {
        return this.exceptions.record(exception);
    }

    @Override
    public Result include(String key, Object value) {
        logger.debug("including attribute {}: {}", (Object)key, value);
        this.includedAttributes.put(key, value);
        this.request.setAttribute(key, value);
        return this;
    }

    @Override
    public boolean used() {
        return this.responseCommitted;
    }

    @Override
    public Map<String, Object> included() {
        return Collections.unmodifiableMap(this.includedAttributes);
    }

    @Override
    public Result include(Object value) {
        if (value == null) {
            return this;
        }
        String key = this.extractor.nameFor(value.getClass());
        return this.include(key, value);
    }
}

