/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorHandlerFactory;
import br.com.caelum.vraptor.interceptor.InterceptorRegistry;
import java.util.LinkedList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InterceptorStackHandlersCache {
    private final LinkedList<InterceptorHandler> interceptorHandlers = new LinkedList();
    private final InterceptorRegistry registry;
    private final InterceptorHandlerFactory handlerFactory;
    private final Logger logger = LoggerFactory.getLogger(InterceptorStackHandlersCache.class);

    protected InterceptorStackHandlersCache() {
        this(null, null);
    }

    @Inject
    public InterceptorStackHandlersCache(InterceptorRegistry registry, InterceptorHandlerFactory handlerFactory) {
        this.registry = registry;
        this.handlerFactory = handlerFactory;
    }

    public void init() {
        for (Class<?> interceptor : this.registry.all()) {
            this.logger.debug("Caching {} ", (Object)interceptor.getName());
            InterceptorHandler handlerFor = this.handlerFactory.handlerFor(interceptor);
            this.interceptorHandlers.addLast(handlerFor);
        }
    }

    public LinkedList<InterceptorHandler> getInterceptorHandlers() {
        return new LinkedList<InterceptorHandler>(this.interceptorHandlers);
    }
}

