/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Try;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.observer.ExecuteMethodExceptionHandler;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class ToInstantiateInterceptorHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ToInstantiateInterceptorHandler.class);
    private final Container container;
    private final Class<?> type;
    private final ExecuteMethodExceptionHandler executeMethodExceptionHandler;

    public ToInstantiateInterceptorHandler(Container container, Class<?> type, ExecuteMethodExceptionHandler executeMethodExceptionHandler) {
        this.container = container;
        this.type = type;
        this.executeMethodExceptionHandler = executeMethodExceptionHandler;
    }

    @Override
    public void execute(InterceptorStack stack, ControllerMethod method, Object controllerInstance) throws InterceptionException {
        Interceptor interceptor = (Interceptor)this.container.instanceFor(this.type);
        if (interceptor == null) {
            throw new InterceptionException("Unable to instantiate interceptor for " + this.type.getName() + ": the container returned null.");
        }
        if (interceptor.accepts(method)) {
            logger.debug("Invoking interceptor {}", (Object)interceptor.getClass().getSimpleName());
            this.executeSafely(stack, method, controllerInstance, interceptor);
        } else {
            stack.next(method, controllerInstance);
        }
    }

    private void executeSafely(final InterceptorStack stack, final ControllerMethod method, final Object controllerInstance, final Interceptor interceptor) {
        Try result = Try.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                interceptor.intercept(stack, method, controllerInstance);
                return null;
            }
        });
        if (result.failed()) {
            this.executeMethodExceptionHandler.handle(result.getException());
        }
    }

    public String toString() {
        return "ToInstantiateHandler for " + this.type.getName();
    }
}

