/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.environment;

import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.environment.Property;
import com.google.common.base.Strings;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class EnvironmentPropertyProducer {
    private final Environment environment;

    protected EnvironmentPropertyProducer() {
        this(null);
    }

    @Inject
    public EnvironmentPropertyProducer(Environment environment) {
        this.environment = environment;
    }

    @Produces
    @Property
    public String get(InjectionPoint ip) {
        String defaultValue;
        Annotated annotated = ip.getAnnotated();
        Property property = (Property)annotated.getAnnotation(Property.class);
        String key = property.value();
        if (Strings.isNullOrEmpty((String)key)) {
            key = ip.getMember().getName();
        }
        if (!Strings.isNullOrEmpty((String)(defaultValue = property.defaultValue()))) {
            return this.environment.get(key, defaultValue);
        }
        return this.environment.get(key);
    }
}

