/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.http.MutableRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class VRaptorRequest
extends HttpServletRequestWrapper
implements MutableRequest {
    private static final Logger logger = LoggerFactory.getLogger(VRaptorRequest.class);
    private final Map<String, String[]> extraParameters = new HashMap<String, String[]>();

    public VRaptorRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        if (this.extraParameters.containsKey(name)) {
            return this.extraParameters.get(name)[0];
        }
        return super.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.extraParameters.containsKey(name)) {
            return this.extraParameters.get(name);
        }
        return super.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> complete = new HashMap<String, String[]>(super.getParameterMap());
        complete.putAll(this.extraParameters);
        return complete;
    }

    @Override
    public void setParameter(String key, String ... value) {
        logger.debug("Setting {} with {}", (Object)key, (Object)value);
        this.extraParameters.put(key, value);
    }

    @Override
    public String getRequestedUri() {
        if (this.getAttribute("javax.servlet.include.request_uri") != null) {
            return (String)this.getAttribute("javax.servlet.include.request_uri");
        }
        String uri = VRaptorRequest.getRelativeRequestURI(this);
        return uri.replaceFirst("(?i);jsessionid=.*$", "");
    }

    public static String getRelativeRequestURI(HttpServletRequest request) {
        if ("/".equals(request.getContextPath())) {
            return request.getRequestURI();
        }
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public String toString() {
        return String.format("[VRaptorRequest %s]", this.getRequest());
    }
}

