/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.TwoWayConverter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.EncodingHandler;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Vetoed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class DefaultParametersControl
implements ParametersControl {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParametersControl.class);
    private final List<String> parameters = new ArrayList<String>();
    private final Pattern pattern;
    private final String originalPattern;
    private final Converters converters;
    private final Evaluator evaluator;
    private EncodingHandler encodingHandler;

    public DefaultParametersControl(String originalPattern, Map<String, String> parameterPatterns, Converters converters, Evaluator evaluator, EncodingHandler encodingHandler) {
        this.originalPattern = originalPattern;
        this.converters = converters;
        this.encodingHandler = encodingHandler;
        this.pattern = this.compilePattern(originalPattern, parameterPatterns);
        this.evaluator = evaluator;
    }

    public DefaultParametersControl(String originalPattern, Converters converters, Evaluator evaluator, EncodingHandler encodingHandler) {
        this(originalPattern, Collections.emptyMap(), converters, evaluator, encodingHandler);
    }

    private Pattern compilePattern(String originalPattern, Map<String, String> parameterPatterns) {
        HashMap<String, String> parameters = new HashMap<String, String>(parameterPatterns);
        Matcher matcher = Pattern.compile("\\{((?=[^\\{]+?[\\{])[^\\}]+?\\}|[^\\}]+?)\\}").matcher(originalPattern);
        while (matcher.find()) {
            String defaultPattern;
            String value = matcher.group(1);
            String string = value.matches("^[^:]+\\*$") ? ".*" : (defaultPattern = value.indexOf(":") >= 0 ? value.replaceAll("^[^\\:]+?:", "") : "[^/]*");
            if (!parameters.containsKey(value)) {
                parameters.put(value, defaultPattern);
            }
            this.parameters.add(value.replaceAll("(\\:.*|\\*)$", ""));
        }
        String patternUri = originalPattern;
        patternUri = patternUri.replaceAll("/\\*", "/.*");
        for (Map.Entry parameter : parameters.entrySet()) {
            patternUri = patternUri.replace("{" + (String)parameter.getKey() + "}", "(" + (String)parameter.getValue() + ")");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("For {} retrieved {} with {}", new Object[]{originalPattern, patternUri, parameters});
        }
        return Pattern.compile(patternUri);
    }

    @Override
    public String fillUri(Parameter[] paramNames, Object ... paramValues) {
        if (paramNames.length != paramValues.length) {
            String message = String.format("paramNames must have the same length as paramValues. Names: %s Values: %s", Arrays.toString(paramNames), Arrays.toString(paramValues));
            throw new IllegalArgumentException(message);
        }
        String[] splittedPatterns = StringUtils.extractParameters(this.originalPattern);
        String base = this.originalPattern;
        for (int i = 0; i < this.parameters.size(); ++i) {
            Class<?> type;
            String key = this.parameters.get(i);
            Object param = this.selectParam(key, paramNames, paramValues);
            Object result = this.evaluator.get(param, key);
            if (result != null && this.converters.existsTwoWayFor(type = result.getClass())) {
                TwoWayConverter<?> converter = this.converters.twoWayConverterFor(type);
                result = converter.convert(result);
            }
            String parameter = this.encodeParameter(result == null ? "" : result.toString());
            base = base.replace("{" + splittedPatterns[i] + "}", result == null ? "" : parameter);
        }
        return base.replaceAll("\\.\\*", "");
    }

    private String encodeParameter(String parameter) {
        try {
            return URLEncoder.encode(parameter, this.encodingHandler.getEncoding());
        }
        catch (Exception e) {
            logger.warn("Can't encode parameter : {} with encoding : {}", (Object)parameter, (Object)this.encodingHandler.getEncoding());
            return parameter;
        }
    }

    private Object selectParam(String key, Parameter[] paramNames, Object[] paramValues) {
        for (int i = 0; i < paramNames.length; ++i) {
            if (!key.matches("^" + paramNames[i].getName() + "(\\..*|$)")) continue;
            return paramValues[i];
        }
        return null;
    }

    @Override
    public boolean matches(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    @Override
    public void fillIntoRequest(String uri, MutableRequest request) {
        Matcher m = this.pattern.matcher(uri);
        m.matches();
        for (int i = 1; i <= m.groupCount(); ++i) {
            String name = this.parameters.get(i - 1);
            try {
                request.setParameter(name, URLDecoder.decode(m.group(i), this.encodingHandler.getEncoding()));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error when decoding url parameters");
            }
        }
    }

    @Override
    public String apply(String[] values) {
        String regex = "\\{.*?\\}";
        String result = this.originalPattern;
        for (int i = 0; i < values.length; ++i) {
            result = result.replaceFirst(regex, values[i].replaceAll("\\$", "\\\\\\$"));
        }
        return result.toString();
    }
}

