/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.cache.CacheStore;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.EncodingHandler;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.route.ControllerNotFoundException;
import br.com.caelum.vraptor.http.route.DefaultRouteBuilder;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.http.route.Invocation;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.NoStrategy;
import br.com.caelum.vraptor.http.route.PriorityRoutesList;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.RouteNotFoundException;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.proxy.Proxifier;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultRouter
implements Router {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRouter.class);
    private final Collection<Route> routes = new PriorityRoutesList();
    private final Proxifier proxifier;
    private final TypeFinder finder;
    private final Converters converters;
    private final ParameterNameProvider nameProvider;
    private final Evaluator evaluator;
    private final CacheStore<Invocation, Route> cache;
    private final EncodingHandler encodingHandler;
    private static final Route NULL = new NoStrategy(){

        @Override
        public String urlFor(Class<?> type, Method m, Object ... params) {
            throw new RouteNotFoundException("The selected route is invalid for redirection: " + type + "." + m.getName());
        }
    };

    protected DefaultRouter() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public DefaultRouter(Proxifier proxifier, TypeFinder finder, Converters converters, ParameterNameProvider nameProvider, Evaluator evaluator, EncodingHandler encodingHandler, CacheStore<Invocation, Route> cache) {
        this.proxifier = proxifier;
        this.finder = finder;
        this.converters = converters;
        this.nameProvider = nameProvider;
        this.evaluator = evaluator;
        this.encodingHandler = encodingHandler;
        this.cache = cache;
    }

    @Override
    public RouteBuilder builderFor(String uri) {
        return new DefaultRouteBuilder(this.proxifier, this.finder, this.converters, this.nameProvider, this.evaluator, uri, this.encodingHandler);
    }

    @Override
    public void add(Route r) {
        this.routes.add(r);
    }

    @Override
    public ControllerMethod parse(String uri, HttpMethod method, MutableRequest request) throws MethodNotAllowedException {
        Collection<Route> routesMatchingUriAndMethod = this.routesMatchingUriAndMethod(uri, method);
        Iterator<Route> iterator = routesMatchingUriAndMethod.iterator();
        Route route = iterator.next();
        this.checkIfThereIsAnotherRoute(uri, method, iterator, route);
        return route.controllerMethod(request, uri);
    }

    private void checkIfThereIsAnotherRoute(String uri, HttpMethod method, Iterator<Route> iterator, Route route) {
        if (iterator.hasNext()) {
            Route otherRoute = iterator.next();
            Preconditions.checkState((route.getPriority() != otherRoute.getPriority() ? 1 : 0) != 0, (String)"There are two rules that matches the uri '%s' with method %s: %s, %s with same priority. Consider using @Path priority attribute.", (Object[])new Object[]{uri, method, route, otherRoute});
        }
    }

    private Collection<Route> routesMatchingUriAndMethod(String uri, HttpMethod method) {
        ImmutableSet routesMatchingMethod = FluentIterable.from(this.routesMatchingUri(uri)).filter(this.allow(method)).toSet();
        if (routesMatchingMethod.isEmpty()) {
            EnumSet<HttpMethod> allowed = this.allowedMethodsFor(uri);
            throw new MethodNotAllowedException(allowed, method.toString());
        }
        return routesMatchingMethod;
    }

    @Override
    public EnumSet<HttpMethod> allowedMethodsFor(String uri) {
        EnumSet<HttpMethod> allowed = EnumSet.noneOf(HttpMethod.class);
        for (Route route : this.routesMatchingUri(uri)) {
            allowed.addAll(route.allowedMethods());
        }
        return allowed;
    }

    private Collection<Route> routesMatchingUri(String uri) {
        ImmutableSet routesMatchingURI = FluentIterable.from(this.routes).filter(this.canHandle(uri)).toSet();
        if (routesMatchingURI.isEmpty()) {
            throw new ControllerNotFoundException();
        }
        return routesMatchingURI;
    }

    @Override
    public <T> String urlFor(Class<T> type, final Method method, Object ... params) {
        final Class<T> rawtype = this.proxifier.isProxyType(type) ? type.getSuperclass() : type;
        Invocation invocation = new Invocation(rawtype, method);
        Route route = this.cache.fetch(invocation, new Supplier<Route>(){

            public Route get() {
                return (Route)FluentIterable.from((Iterable)DefaultRouter.this.routes).filter(DefaultRouter.this.canHandle(rawtype, method)).first().or((Object)NULL);
            }
        });
        logger.debug("Selected route for {} is {}", (Object)method, (Object)route);
        String url = route.urlFor(type, method, params);
        logger.debug("Returning URL {} for {}", (Object)url, (Object)route);
        return url;
    }

    @Override
    public List<Route> allRoutes() {
        return Collections.unmodifiableList(new ArrayList<Route>(this.routes));
    }

    private Predicate<Route> canHandle(final Class<?> type, final Method method) {
        return new Predicate<Route>(){

            public boolean apply(Route route) {
                return route.canHandle(type, method);
            }
        };
    }

    private Predicate<Route> canHandle(final String uri) {
        return new Predicate<Route>(){

            public boolean apply(Route route) {
                return route.canHandle(uri);
            }
        };
    }

    private Predicate<Route> allow(final HttpMethod method) {
        return new Predicate<Route>(){

            public boolean apply(Route route) {
                return route.allowedMethods().contains((Object)method);
            }
        };
    }
}

