/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultTypeFinder
implements TypeFinder {
    private final ParameterNameProvider provider;
    private final ReflectionProvider reflectionProvider;

    protected DefaultTypeFinder() {
        this(null, null);
    }

    @Inject
    public DefaultTypeFinder(ParameterNameProvider provider, ReflectionProvider reflectionProvider) {
        this.provider = provider;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public Map<String, Class<?>> getParameterTypes(Method method, String[] parameterPaths) {
        HashMap types = new HashMap();
        Parameter[] parametersFor = this.provider.parametersFor(method);
        for (String path : parameterPaths) {
            for (Parameter parameter : parametersFor) {
                if (!path.startsWith(parameter.getName() + ".") && !path.equals(parameter.getName())) continue;
                String[] items = path.split("\\.");
                Class<?> type = parameter.getType();
                for (int j = 1; j < items.length; ++j) {
                    String item = items[j];
                    try {
                        type = this.reflectionProvider.getMethod(type, "get" + StringUtils.capitalize(item), new Class[0]).getReturnType();
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Parameters paths are invalid: " + Arrays.toString(parameterPaths) + " for method " + method, e);
                    }
                }
                types.put(path, type);
            }
        }
        return types;
    }
}

