/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.Route;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class FixedMethodStrategy
implements Route {
    private final ControllerMethod controllerMethod;
    private final EnumSet<HttpMethod> methods;
    private final ParametersControl parameters;
    private final int priority;
    private final String originalUri;
    private final Parameter[] parameterNames;

    public FixedMethodStrategy(String originalUri, ControllerMethod method, Set<HttpMethod> methods, ParametersControl control, int priority, Parameter[] parameterNames) {
        this.originalUri = originalUri;
        this.parameterNames = parameterNames;
        this.methods = methods.isEmpty() ? EnumSet.allOf(HttpMethod.class) : EnumSet.copyOf(methods);
        this.parameters = control;
        this.controllerMethod = method;
        this.priority = priority;
    }

    @Override
    public boolean canHandle(Class<?> type, Method method) {
        Method getMethod = this.controllerMethod.getMethod();
        return type.equals(this.controllerMethod.getController().getType()) && method.getName().equals(getMethod.getName()) && Arrays.equals(method.getParameterTypes(), getMethod.getParameterTypes());
    }

    @Override
    public ControllerMethod controllerMethod(MutableRequest request, String uri) {
        this.parameters.fillIntoRequest(uri, request);
        return this.controllerMethod;
    }

    @Override
    public EnumSet<HttpMethod> allowedMethods() {
        return this.methods;
    }

    @Override
    public boolean canHandle(String uri) {
        return this.parameters.matches(uri);
    }

    @Override
    public String urlFor(Class<?> type, Method m, Object ... params) {
        return this.parameters.fillUri(this.parameterNames, params);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getOriginalUri() {
        return this.originalUri;
    }

    @Override
    public ControllerMethod getControllerMethod() {
        return this.controllerMethod;
    }

    public String toString() {
        return String.format("[FixedMethodStrategy: %-65s %-70s %s]", this.originalUri, this.controllerMethod.getMethod().getName(), this.methods.size() == HttpMethod.values().length ? "ALL" : this.methods);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.originalUri, this.controllerMethod);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FixedMethodStrategy other = (FixedMethodStrategy)obj;
        return Objects.equals(this.methods, other.methods) && Objects.equals(this.originalUri, other.originalUri) && Objects.equals(this.controllerMethod, other.controllerMethod);
    }
}

