/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.route.Evaluator;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JavaEvaluator
implements Evaluator {
    private final ReflectionProvider reflectionProvider;

    protected JavaEvaluator() {
        this(null);
    }

    @Inject
    public JavaEvaluator(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public Object get(Object root, String path) {
        if (root == null) {
            return null;
        }
        String[] paths = path.split("[\\]\\.]");
        Object current = root;
        for (int i = 1; i < paths.length; ++i) {
            try {
                current = this.navigate(current, paths[i]);
            }
            catch (Exception e) {
                throw new VRaptorException("Unable to evaluate expression " + path, e);
            }
            if (current != null) continue;
            return "";
        }
        return current;
    }

    private Object navigate(Object current, String path) {
        int index = path.indexOf("[");
        int position = -1;
        if (index != -1) {
            position = Integer.parseInt(path.substring(index + 1));
            path = path.substring(0, index);
        }
        Object instance = this.reflectionProvider.invokeGetter(current, path);
        if (index != -1) {
            instance = this.access(instance, position);
        }
        return instance;
    }

    private Object access(Object current, int position) {
        if (current.getClass().isArray()) {
            return Array.get(current, position);
        }
        if (Collection.class.isAssignableFrom(current.getClass())) {
            return Iterables.get((Iterable)((Collection)current), (int)position);
        }
        throw new VRaptorException("Unable to access position of a" + current.getClass().getName() + ".");
    }
}

