/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.Delete;
import br.com.caelum.vraptor.Get;
import br.com.caelum.vraptor.Options;
import br.com.caelum.vraptor.Patch;
import br.com.caelum.vraptor.Path;
import br.com.caelum.vraptor.Post;
import br.com.caelum.vraptor.Put;
import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.RoutesParser;
import br.com.caelum.vraptor.util.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class PathAnnotationRoutesParser
implements RoutesParser {
    private final Router router;
    private ReflectionProvider reflectionProvider;

    protected PathAnnotationRoutesParser() {
        this(null, null);
    }

    @Inject
    public PathAnnotationRoutesParser(Router router, ReflectionProvider reflectionProvider) {
        this.router = router;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public List<Route> rulesFor(BeanClass controller) {
        Class<?> baseType = controller.getType();
        return this.registerRulesFor(baseType);
    }

    protected List<Route> registerRulesFor(Class<?> baseType) {
        EnumSet<HttpMethod> typeMethods = this.getHttpMethods(baseType);
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Method javaMethod : baseType.getMethods()) {
            String[] uris;
            if (!this.isEligible(javaMethod)) continue;
            for (String uri : uris = this.getURIsFor(javaMethod, baseType)) {
                RouteBuilder rule = this.router.builderFor(uri);
                EnumSet<HttpMethod> methods = this.getHttpMethods(javaMethod);
                rule.with(methods.isEmpty() ? typeMethods : methods);
                if (javaMethod.isAnnotationPresent(Path.class)) {
                    rule.withPriority(javaMethod.getAnnotation(Path.class).priority());
                }
                if (this.getUris(javaMethod).length > 0) {
                    rule.withPriority(0x3FFFFFFF);
                }
                rule.is(baseType, javaMethod);
                routes.add(rule.build());
            }
        }
        return routes;
    }

    private EnumSet<HttpMethod> getHttpMethods(AnnotatedElement annotated) {
        EnumSet<HttpMethod> methods = EnumSet.noneOf(HttpMethod.class);
        for (HttpMethod method : HttpMethod.values()) {
            if (!annotated.isAnnotationPresent(method.getAnnotation())) continue;
            methods.add(method);
        }
        return methods;
    }

    protected boolean isEligible(Method javaMethod) {
        return Modifier.isPublic(javaMethod.getModifiers()) && !Modifier.isStatic(javaMethod.getModifiers()) && !javaMethod.isBridge() && !javaMethod.getDeclaringClass().equals(Object.class);
    }

    protected String[] getURIsFor(Method javaMethod, Class<?> type) {
        if (javaMethod.isAnnotationPresent(Path.class)) {
            String[] uris = javaMethod.getAnnotation(Path.class).value();
            Preconditions.checkArgument((uris.length > 0 ? 1 : 0) != 0, (String)"You must specify at least one path on @Path at %s", (Object[])new Object[]{javaMethod});
            Preconditions.checkArgument((this.getUris(javaMethod).length == 0 ? 1 : 0) != 0, (String)"You should specify paths either in @Path(\"/path\") or @Get(\"/path\") (or @Post, @Put, @Delete), not both at %s", (Object[])new Object[]{javaMethod});
            this.fixURIs(type, uris);
            return uris;
        }
        String[] uris = this.getUris(javaMethod);
        if (uris.length > 0) {
            this.fixURIs(type, uris);
            return uris;
        }
        return new String[]{this.defaultUriFor(this.extractControllerNameFrom(type), javaMethod.getName())};
    }

    protected String[] getUris(Method javaMethod) {
        Annotation method = (Annotation)FluentIterable.from(Arrays.asList(javaMethod.getAnnotations())).filter(this.instanceOfMethodAnnotation()).first().orNull();
        if (method == null) {
            return new String[0];
        }
        return (String[])this.reflectionProvider.invoke((Object)method, "value", new Object[0]);
    }

    protected void fixURIs(Class<?> type, String[] uris) {
        String prefix = this.extractPrefix(type);
        for (int i = 0; i < uris.length; ++i) {
            uris[i] = Strings.isNullOrEmpty((String)prefix) ? PathAnnotationRoutesParser.fixLeadingSlash(uris[i]) : (Strings.isNullOrEmpty((String)uris[i]) ? prefix : this.removeTrailingSlash(prefix) + PathAnnotationRoutesParser.fixLeadingSlash(uris[i]));
        }
    }

    protected String removeTrailingSlash(String prefix) {
        return prefix.replaceFirst("/$", "");
    }

    protected String extractPrefix(Class<?> type) {
        if (type.isAnnotationPresent(Path.class)) {
            String[] uris = type.getAnnotation(Path.class).value();
            Preconditions.checkArgument((uris.length == 1 ? 1 : 0) != 0, (String)"You must specify exactly one path on @Path at %s", (Object[])new Object[]{type});
            return PathAnnotationRoutesParser.fixLeadingSlash(uris[0]);
        }
        return "";
    }

    private static String fixLeadingSlash(String uri) {
        if (!uri.startsWith("/")) {
            return "/" + uri;
        }
        return uri;
    }

    protected String extractControllerNameFrom(Class<?> type) {
        String prefix = this.extractPrefix(type);
        if (Strings.isNullOrEmpty((String)prefix)) {
            String baseName = StringUtils.lowercaseFirst(type.getSimpleName());
            if (baseName.endsWith("Controller")) {
                return "/" + baseName.substring(0, baseName.lastIndexOf("Controller"));
            }
            return "/" + baseName;
        }
        return prefix;
    }

    protected String defaultUriFor(String controllerName, String methodName) {
        return controllerName + "/" + methodName;
    }

    private Predicate<Annotation> instanceOfMethodAnnotation() {
        return Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(Get.class), Predicates.instanceOf(Post.class), Predicates.instanceOf(Put.class), Predicates.instanceOf(Delete.class), Predicates.instanceOf(Options.class), Predicates.instanceOf(Patch.class)});
    }
}

