/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Accepts;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.interceptor.ValidationRule;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class AcceptsNeedReturnBooleanValidationRule
implements ValidationRule {
    private final StepInvoker invoker;

    protected AcceptsNeedReturnBooleanValidationRule() {
        this(null);
    }

    @Inject
    public AcceptsNeedReturnBooleanValidationRule(StepInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void validate(Class<?> originalType, List<Method> methods) {
        Method accepts = this.invoker.findMethod(methods, Accepts.class, originalType);
        if (accepts != null && !this.isBooleanReturn(accepts.getReturnType())) {
            throw new InterceptionException(String.format("@%s method must return boolean", Accepts.class.getSimpleName()));
        }
    }

    private boolean isBooleanReturn(Class<?> returnType) {
        return returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE);
    }
}

