/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.interceptor.AcceptsConstraint;
import br.com.caelum.vraptor.interceptor.AcceptsValidator;
import br.com.caelum.vraptor.ioc.Container;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class CustomAcceptsVerifier {
    private final Container container;

    protected CustomAcceptsVerifier() {
        this(null);
    }

    @Inject
    public CustomAcceptsVerifier(Container container) {
        this.container = container;
    }

    public boolean isValid(Object interceptor, ControllerMethod controllerMethod, ControllerInstance controllerInstance, List<Annotation> constraints) {
        for (Annotation annotation : constraints) {
            AcceptsConstraint constraint = annotation.annotationType().getAnnotation(AcceptsConstraint.class);
            Class<? extends AcceptsValidator<?>> validatorClass = constraint.value();
            AcceptsValidator<?> validator = this.container.instanceFor(validatorClass);
            validator.initialize(annotation);
            if (validator.validate(controllerMethod, controllerInstance)) continue;
            return false;
        }
        return true;
    }

    public static List<Annotation> getCustomAcceptsAnnotations(Class<?> clazz) {
        return FluentIterable.from(Arrays.asList(clazz.getAnnotations())).filter(CustomAcceptsVerifier.acceptsConstraintMatcher()).toList();
    }

    private static Predicate<Annotation> acceptsConstraintMatcher() {
        return new Predicate<Annotation>(){

            public boolean apply(Annotation element) {
                return element != null && element.annotationType().isAnnotationPresent(AcceptsConstraint.class);
            }
        };
    }
}

