/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.interceptor.Interceptor;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts
public class FlashInterceptor
implements Interceptor {
    static final String FLASH_INCLUDED_PARAMETERS = "br.com.caelum.vraptor.flash.parameters";
    private static final Logger LOGGER = LoggerFactory.getLogger(FlashInterceptor.class);
    private final HttpSession session;
    private final Result result;
    private final MutableResponse response;

    protected FlashInterceptor() {
        this(null, null, null);
    }

    @Inject
    public FlashInterceptor(HttpSession session, Result result, MutableResponse response) {
        this.session = session;
        this.result = result;
        this.response = response;
    }

    @Override
    public boolean accepts(ControllerMethod method) {
        return true;
    }

    @Override
    public void intercept(InterceptorStack stack, ControllerMethod method, Object controllerInstance) throws InterceptionException {
        HashMap parameters = (HashMap)this.session.getAttribute(FLASH_INCLUDED_PARAMETERS);
        if (parameters != null) {
            parameters = new HashMap(parameters);
            this.session.removeAttribute(FLASH_INCLUDED_PARAMETERS);
            for (Map.Entry parameter : parameters.entrySet()) {
                this.result.include((String)parameter.getKey(), parameter.getValue());
            }
        }
        this.response.addRedirectListener(new MutableResponse.RedirectListener(){

            @Override
            public void beforeRedirect() {
                Map<String, Object> included = FlashInterceptor.this.result.included();
                if (!included.isEmpty()) {
                    try {
                        FlashInterceptor.this.session.setAttribute(FlashInterceptor.FLASH_INCLUDED_PARAMETERS, new HashMap<String, Object>(included));
                    }
                    catch (IllegalStateException e) {
                        LOGGER.warn("HTTP Session was invalidated. It is not possible to include Result parameters on Flash Scope", (Throwable)e);
                    }
                }
            }
        });
        stack.next(method, controllerInstance);
    }
}

