/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class Graph<E> {
    private final Multimap<E, E> graph = LinkedHashMultimap.create();
    private List<E> orderedList;
    private final Lock lock = new ReentrantLock();

    public void addEdge(E from, E to) {
        Preconditions.checkState((this.orderedList == null ? 1 : 0) != 0, (Object)"You shouldn't add more interceptors after ordering. Please notify vraptor developers.");
        this.graph.put(from, to);
    }

    public void addEdges(E from, E ... tos) {
        if (tos.length == 0) {
            this.addEdge(from, null);
        } else {
            for (E to : tos) {
                this.addEdge(from, to);
            }
        }
    }

    public List<E> topologicalOrder() {
        if (this.orderedList == null) {
            this.lock.lock();
            try {
                if (this.orderedList == null) {
                    this.orderedList = this.orderTopologically();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.orderedList;
    }

    private List<E> orderTopologically() {
        ArrayList<E> list = new ArrayList<E>();
        while (!this.graph.keySet().isEmpty()) {
            Set<E> roots = this.findRoots();
            if (roots.isEmpty()) {
                throw new IllegalStateException("There is a cycle on the interceptor sequence: \n" + this.cycle());
            }
            list.addAll(roots);
            this.removeRoots(roots);
        }
        return list;
    }

    private void removeRoots(Set<E> roots) {
        for (E root : roots) {
            this.graph.removeAll(root);
        }
    }

    private Set<E> findRoots() {
        return Sets.difference((Set)this.graph.keySet(), (Set)Sets.newHashSet((Iterable)this.graph.values())).immutableCopy();
    }

    private String cycle() {
        this.removeLeaves();
        return this.findCycle().toString();
    }

    private List<E> findCycle() {
        E node = this.firstElement(this.graph.keySet());
        ArrayList<E> cycle = new ArrayList<E>();
        do {
            cycle.add(node);
        } while (!cycle.contains(node = this.firstElement(this.graph.get(node))));
        return cycle.subList(cycle.indexOf(node), cycle.size());
    }

    private E firstElement(Iterable<E> elements) {
        return elements.iterator().next();
    }

    private void removeLeaves() {
        Set<E> leaves = this.findLeaves();
        if (leaves.isEmpty()) {
            return;
        }
        for (Object key : Sets.newHashSet((Iterable)this.graph.keySet())) {
            for (E value : leaves) {
                this.graph.remove(key, value);
            }
        }
        this.removeLeaves();
    }

    private Set<E> findLeaves() {
        return Sets.difference((Set)Sets.newHashSet((Iterable)this.graph.values()), (Set)this.graph.keySet());
    }
}

