/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.interceptor.ValidationRule;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@Dependent
public class InterceptorValidator {
    @Inject
    @Any
    private Instance<ValidationRule> validationRules;
    @Inject
    @Any
    private StepInvoker stepInvoker;

    public void validate(Class<?> originalType) {
        boolean implementsInterceptor = Interceptor.class.isAssignableFrom(originalType);
        boolean containsIntercepts = originalType.isAnnotationPresent(Intercepts.class);
        Preconditions.checkState((implementsInterceptor || containsIntercepts ? 1 : 0) != 0, (String)"Annotation @Intercepts found in %s, but it is not an Interceptor.", (Object[])new Object[]{originalType});
        this.applyNewInterceptorValidationRules(originalType, implementsInterceptor);
    }

    private void applyNewInterceptorValidationRules(Class<?> originalType, boolean implementsInterceptor) {
        if (!implementsInterceptor) {
            List<Method> allMethods = this.stepInvoker.findAllMethods(originalType);
            for (ValidationRule validationRule : this.validationRules) {
                validationRule.validate(originalType, allMethods);
            }
        }
    }
}

