/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Accepts;
import br.com.caelum.vraptor.AfterCall;
import br.com.caelum.vraptor.AroundCall;
import br.com.caelum.vraptor.BeforeCall;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.SimpleInterceptorStack;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.interceptor.ValidationRule;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class NoStackParamValidationRule
implements ValidationRule {
    private final StepInvoker invoker;

    protected NoStackParamValidationRule() {
        this(null);
    }

    @Inject
    public NoStackParamValidationRule(StepInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void validate(Class<?> originalType, List<Method> methods) {
        Method aroundCall = this.invoker.findMethod(methods, AroundCall.class, originalType);
        Method afterCall = this.invoker.findMethod(methods, AfterCall.class, originalType);
        Method beforeCall = this.invoker.findMethod(methods, BeforeCall.class, originalType);
        Method accepts = this.invoker.findMethod(methods, Accepts.class, originalType);
        String interceptorStack = InterceptorStack.class.getName();
        String simpleInterceptorStack = SimpleInterceptorStack.class.getName();
        Preconditions.checkState((aroundCall == null || this.containsStack(aroundCall) ? 1 : 0) != 0, (String)"@AroundCall method must receive %s or %s", (Object[])new Object[]{interceptorStack, simpleInterceptorStack});
        Preconditions.checkState((!this.containsStack(beforeCall) && !this.containsStack(afterCall) && !this.containsStack(accepts) ? 1 : 0) != 0, (String)"Non @AroundCall method must not receive %s or %s", (Object[])new Object[]{interceptorStack, simpleInterceptorStack});
    }

    private boolean containsStack(Method method) {
        if (method == null) {
            return false;
        }
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        return FluentIterable.from(parameterTypes).anyMatch(this.hasStack());
    }

    private Predicate<Class<?>> hasStack() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return SimpleInterceptorStack.class.isAssignableFrom(input) || InterceptorStack.class.isAssignableFrom(input);
            }
        };
    }
}

