/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.interceptor.AcceptsForPackages;
import br.com.caelum.vraptor.interceptor.AcceptsValidator;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;

@Dependent
public class PackagesAcceptor
implements AcceptsValidator<AcceptsForPackages> {
    private List<String> allowedPackages;

    @Override
    public boolean validate(ControllerMethod method, ControllerInstance instance) {
        String controllerPackageName = instance.getBeanClass().getPackageName();
        return FluentIterable.from(this.allowedPackages).anyMatch(this.currentOrSubpackage(controllerPackageName));
    }

    private Predicate<String> currentOrSubpackage(final String controllerPackageName) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return controllerPackageName.startsWith(input);
            }
        };
    }

    @Override
    public void initialize(AcceptsForPackages annotation) {
        this.allowedPackages = Arrays.asList(annotation.value());
    }
}

