/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.core.ControllerQualifier;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.RoutesParser;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ControllerHandler {
    private final Logger logger = LoggerFactory.getLogger(ControllerHandler.class);
    private final Router router;
    private final RoutesParser parser;
    private final ServletContext context;

    protected ControllerHandler() {
        this(null, null, null);
    }

    @Inject
    public ControllerHandler(Router router, RoutesParser parser, ServletContext context) {
        this.router = router;
        this.parser = parser;
        this.context = context;
    }

    public void handle(@Observes @ControllerQualifier BeanClass annotatedType) {
        this.logger.debug("Found controller: {}", (Object)annotatedType);
        for (Route route : this.parser.rulesFor(annotatedType)) {
            this.router.add(route);
        }
        this.registerLinkToClass(annotatedType);
    }

    private void registerLinkToClass(BeanClass annotatedType) {
        this.context.setAttribute(annotatedType.getType().getSimpleName(), (Object)annotatedType);
    }
}

