/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc;

import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.core.InterceptsQualifier;
import br.com.caelum.vraptor.interceptor.InterceptorRegistry;
import br.com.caelum.vraptor.interceptor.InterceptorValidator;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class InterceptorStereotypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(InterceptorStereotypeHandler.class);
    private final InterceptorRegistry registry;
    private final InterceptorValidator interceptorValidator;

    protected InterceptorStereotypeHandler() {
        this(null, null);
    }

    @Inject
    public InterceptorStereotypeHandler(InterceptorRegistry registry, InterceptorValidator validator) {
        this.registry = registry;
        this.interceptorValidator = validator;
    }

    public void handle(@Observes @InterceptsQualifier BeanClass beanClass) {
        Class<?> originalType = beanClass.getType();
        this.interceptorValidator.validate(originalType);
        logger.debug("Found interceptor for {}", originalType);
        this.registry.register(originalType);
    }
}

