/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.events.RequestSucceded;
import br.com.caelum.vraptor.view.Results;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ForwardToDefaultView {
    private final Result result;
    private static final Logger logger = LoggerFactory.getLogger(ForwardToDefaultView.class);

    protected ForwardToDefaultView() {
        this(null);
    }

    @Inject
    public ForwardToDefaultView(Result result) {
        this.result = result;
    }

    public void forward(@Observes RequestSucceded event) {
        if (this.result.used() || event.getResponse().isCommitted()) {
            logger.debug("Request already dispatched and commited somewhere else, not forwarding.");
            return;
        }
        logger.debug("forwarding to the dafault page for this logic");
        this.result.use(Results.page()).defaultView();
    }
}

