/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.HeaderParam;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.events.InterceptorsReady;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.ValuedParameter;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Validator;
import br.com.caelum.vraptor.view.FlashScope;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ParametersInstantiator {
    private static final Logger logger = LoggerFactory.getLogger(ParametersInstantiator.class);
    private final ParametersProvider provider;
    private final MethodInfo methodInfo;
    private final Validator validator;
    private final MutableRequest request;
    private final FlashScope flash;
    private final List<Message> errors = new ArrayList<Message>();

    protected ParametersInstantiator() {
        this(null, null, null, null, null);
    }

    @Inject
    public ParametersInstantiator(ParametersProvider provider, MethodInfo methodInfo, Validator validator, MutableRequest request, FlashScope flash) {
        this.provider = provider;
        this.methodInfo = methodInfo;
        this.validator = validator;
        this.request = request;
        this.flash = flash;
    }

    public void instantiate(@Observes InterceptorsReady event) {
        if (!this.hasInstantiatableParameters()) {
            return;
        }
        this.fixIndexedParameters(this.request);
        this.addHeaderParametersToAttribute();
        Object[] values = this.getParametersForCurrentMethod();
        this.validator.addAll(this.errors);
        logger.debug("Conversion errors: {}", this.errors);
        logger.debug("Parameter values for {} are {}", (Object)this.methodInfo.getControllerMethod(), (Object)values);
        ValuedParameter[] valuedParameters = this.methodInfo.getValuedParameters();
        for (int i = 0; i < valuedParameters.length; ++i) {
            Parameter parameter = valuedParameters[i].getParameter();
            if (parameter.isAnnotationPresent(HeaderParam.class)) {
                HeaderParam headerParam = parameter.getAnnotation(HeaderParam.class);
                valuedParameters[i].setValue(this.request.getHeader(headerParam.value()));
                continue;
            }
            ValuedParameter valuedParameter = valuedParameters[i];
            if (valuedParameter.getValue() != null) continue;
            valuedParameter.setValue(values[i]);
        }
    }

    private boolean hasInstantiatableParameters() {
        return this.methodInfo.getControllerMethod().getArity() > 0;
    }

    private void addHeaderParametersToAttribute() {
        for (ValuedParameter param : this.methodInfo.getValuedParameters()) {
            HeaderParam headerParam;
            String value;
            if (!param.getParameter().isAnnotationPresent(HeaderParam.class) || Strings.isNullOrEmpty((String)(value = this.request.getHeader((headerParam = param.getParameter().getAnnotation(HeaderParam.class)).value())))) continue;
            this.request.setParameter(param.getName(), value);
        }
    }

    private void fixIndexedParameters(MutableRequest request) {
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.disallowUsingClassAttribute(name);
            if (!name.contains("[]")) continue;
            String[] values = request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                request.setParameter(name.replace("[]", "[" + i + "]"), values[i]);
            }
        }
    }

    private void disallowUsingClassAttribute(String name) {
        Preconditions.checkArgument((!name.contains(".class.") ? 1 : 0) != 0, (String)"Bug Exploit Attempt with parameter: %s", (Object[])new Object[]{name});
    }

    private Object[] getParametersForCurrentMethod() {
        Object[] args = this.flash.consumeParameters(this.methodInfo.getControllerMethod());
        if (args == null) {
            return this.provider.getParametersFor(this.methodInfo.getControllerMethod(), this.errors);
        }
        return args;
    }
}

