/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.ControllerNotFoundHandler;
import br.com.caelum.vraptor.controller.InvalidInputException;
import br.com.caelum.vraptor.controller.InvalidInputHandler;
import br.com.caelum.vraptor.controller.MethodNotAllowedHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.events.ControllerFound;
import br.com.caelum.vraptor.events.RequestSucceded;
import br.com.caelum.vraptor.events.VRaptorRequestStarted;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.http.UrlToControllerTranslator;
import br.com.caelum.vraptor.http.route.ControllerNotFoundException;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RequestHandlerObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandlerObserver.class);
    private final UrlToControllerTranslator translator;
    private final ControllerNotFoundHandler controllerNotFoundHandler;
    private final MethodNotAllowedHandler methodNotAllowedHandler;
    private final Event<ControllerFound> controllerFoundEvent;
    private final InterceptorStack interceptorStack;
    private final Event<RequestSucceded> endRequestEvent;
    private final InvalidInputHandler invalidInputHandler;

    protected RequestHandlerObserver() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public RequestHandlerObserver(UrlToControllerTranslator translator, ControllerNotFoundHandler controllerNotFoundHandler, MethodNotAllowedHandler methodNotAllowedHandler, Event<ControllerFound> controllerFoundEvent, Event<RequestSucceded> endRequestEvent, InterceptorStack interceptorStack, InvalidInputHandler invalidInputHandler) {
        this.translator = translator;
        this.methodNotAllowedHandler = methodNotAllowedHandler;
        this.controllerNotFoundHandler = controllerNotFoundHandler;
        this.controllerFoundEvent = controllerFoundEvent;
        this.endRequestEvent = endRequestEvent;
        this.interceptorStack = interceptorStack;
        this.invalidInputHandler = invalidInputHandler;
    }

    public void handle(@Observes VRaptorRequestStarted event) {
        MutableResponse response = event.getResponse();
        MutableRequest request = event.getRequest();
        try {
            ControllerMethod method = this.translator.translate(request);
            this.controllerFoundEvent.fire((Object)new ControllerFound(method));
            this.interceptorStack.start();
            this.endRequestEvent.fire((Object)new RequestSucceded(request, response));
        }
        catch (ControllerNotFoundException e) {
            LOGGER.debug("Could not found controller method", (Throwable)e);
            this.controllerNotFoundHandler.couldntFind(event.getChain(), request, response);
        }
        catch (MethodNotAllowedException e) {
            LOGGER.debug("Method is not allowed", (Throwable)e);
            this.methodNotAllowedHandler.deny(request, response, e.getAllowedMethods());
        }
        catch (InvalidInputException e) {
            LOGGER.debug("Invalid input", (Throwable)e);
            this.invalidInputHandler.deny(e);
        }
    }
}

