/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.download;

import br.com.caelum.vraptor.observer.download.ByteArrayDownload;
import br.com.caelum.vraptor.observer.download.FileDownload;
import br.com.caelum.vraptor.observer.download.InputStreamDownload;
import br.com.caelum.vraptor.observer.download.ZipDownload;
import com.thoughtworks.xstream.InitializationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.enterprise.inject.Vetoed;

@Vetoed
public final class DownloadBuilder {
    private DownloadBuilder() {
        throw new InitializationException("Not allowed to initialize");
    }

    public static FileDownloadBuilder of(File file) {
        return new FileDownloadBuilder(file);
    }

    public static InputStreamDownloadBuilder of(InputStream input) {
        return new InputStreamDownloadBuilder(input);
    }

    public static ByteArrayDownloadBuilder of(byte[] input) {
        return new ByteArrayDownloadBuilder(input);
    }

    public static ZipDownloadBuilder of(List<Path> files) {
        return new ZipDownloadBuilder(files);
    }

    public static class ZipDownloadBuilder
    extends AbstractDownloadBuilder<ZipDownloadBuilder> {
        private final List<Path> files;

        ZipDownloadBuilder(List<Path> files) {
            this.files = Objects.requireNonNull(files, "files can't be null");
        }

        public ZipDownload build() {
            return new ZipDownload(this.fileName, this.files);
        }
    }

    public static class ByteArrayDownloadBuilder
    extends AbstractDownloadBuilder<ByteArrayDownloadBuilder> {
        private final byte[] buff;

        ByteArrayDownloadBuilder(byte[] buff) {
            this.buff = Objects.requireNonNull(buff, "byte[] can't be null");
        }

        public ByteArrayDownload build() {
            return new ByteArrayDownload(this.buff, this.contentType, this.fileName, this.doDownload);
        }
    }

    public static class InputStreamDownloadBuilder
    extends AbstractDownloadBuilder<InputStreamDownloadBuilder> {
        private final InputStream input;
        private long size;

        InputStreamDownloadBuilder(InputStream input) {
            this.input = Objects.requireNonNull(input, "InputStream can't be null");
        }

        public InputStreamDownloadBuilder withSize(long size) {
            this.size = size;
            return this;
        }

        public InputStreamDownload build() {
            return new InputStreamDownload(this.input, this.contentType, this.fileName, this.doDownload, this.size);
        }
    }

    public static class FileDownloadBuilder
    extends AbstractDownloadBuilder<FileDownloadBuilder> {
        private final File file;

        FileDownloadBuilder(File file) {
            this.file = Objects.requireNonNull(file, "File can't be null");
        }

        public FileDownload build() throws FileNotFoundException {
            this.fileName = (String)com.google.common.base.Objects.firstNonNull((Object)this.fileName, (Object)this.file.getName());
            return new FileDownload(this.file, this.contentType, this.fileName, this.doDownload);
        }
    }

    static abstract class AbstractDownloadBuilder<T> {
        protected String fileName;
        protected String contentType;
        protected boolean doDownload;

        AbstractDownloadBuilder() {
        }

        public T withFileName(String fileName) {
            this.fileName = fileName;
            return (T)this;
        }

        public T withContentType(String contentType) {
            this.contentType = contentType;
            return (T)this;
        }

        public T downloadable() {
            this.doDownload = true;
            return (T)this;
        }
    }
}

