/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.download;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.events.MethodExecuted;
import br.com.caelum.vraptor.observer.download.ByteArrayDownload;
import br.com.caelum.vraptor.observer.download.Download;
import br.com.caelum.vraptor.observer.download.DownloadView;
import br.com.caelum.vraptor.observer.download.FileDownload;
import br.com.caelum.vraptor.observer.download.InputStreamDownload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DownloadObserver {
    private static final Logger logger = LoggerFactory.getLogger(DownloadObserver.class);

    public void download(@Observes MethodExecuted event, Result result) throws IOException {
        Object methodResult = event.getMethodInfo().getResult();
        Download download = this.resolveDownload(methodResult);
        if (download != null && !result.used()) {
            logger.debug("Sending a file to the client");
            result.use(DownloadView.class).of(download);
        }
    }

    public Download resolveDownload(Object result) throws IOException {
        if (result instanceof InputStream) {
            return new InputStreamDownload((InputStream)result, null, null);
        }
        if (result instanceof byte[]) {
            return new ByteArrayDownload((byte[])result, null, null);
        }
        if (result instanceof File) {
            return new FileDownload((File)result, null, null);
        }
        if (result instanceof Download) {
            return (Download)result;
        }
        return null;
    }
}

