/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.download;

import br.com.caelum.vraptor.observer.download.Download;
import br.com.caelum.vraptor.observer.download.InputStreamDownload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.enterprise.inject.Vetoed;
import javax.servlet.http.HttpServletResponse;

@Vetoed
public class FileDownload
implements Download {
    private final File file;
    private final String contentType;
    private final String fileName;
    private final boolean doDownload;

    public FileDownload(File file, String contentType, String fileName) throws FileNotFoundException {
        this(file, contentType, fileName, false);
    }

    public FileDownload(File file, String contentType) throws FileNotFoundException {
        this(file, contentType, file.getName(), false);
    }

    public FileDownload(File file, String contentType, String fileName, boolean doDownload) throws FileNotFoundException {
        this.file = FileDownload.checkFile(file);
        this.contentType = contentType;
        this.fileName = fileName;
        this.doDownload = doDownload;
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        try (FileInputStream stream = new FileInputStream(this.file);){
            InputStreamDownload download = new InputStreamDownload(stream, this.contentType, this.fileName, this.doDownload, this.file.length());
            download.write(response);
        }
    }

    private static File checkFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getName() + " doesn't exists");
        }
        return file;
    }
}

