/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.download;

import br.com.caelum.vraptor.observer.download.Download;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.inject.Vetoed;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

@Vetoed
public class InputStreamDownload
implements Download {
    private final InputStream stream;
    private final String contentType;
    private final String fileName;
    private final boolean doDownload;
    private final long size;

    public InputStreamDownload(InputStream input, String contentType, String fileName) {
        this(input, contentType, fileName, false, 0L);
    }

    public InputStreamDownload(InputStream input, String contentType, String fileName, boolean doDownload, long size) {
        this.stream = input;
        this.size = size;
        this.contentType = contentType;
        this.fileName = fileName;
        this.doDownload = doDownload;
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        this.writeDetails(response);
        ServletOutputStream out = response.getOutputStream();
        ByteStreams.copy((InputStream)this.stream, (OutputStream)out);
        this.stream.close();
    }

    void writeDetails(HttpServletResponse response) {
        if (this.contentType != null) {
            String contentDisposition = String.format("%s; filename=%s", this.doDownload ? "attachment" : "inline", this.fileName);
            response.setHeader("Content-disposition", contentDisposition);
            response.setHeader("Content-type", this.contentType);
        }
        if (this.size > 0L) {
            response.setHeader("Content-Length", Long.toString(this.size));
        }
    }
}

