/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.upload;

import br.com.caelum.vraptor.events.ControllerFound;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.observer.upload.CommonsUploadedFile;
import br.com.caelum.vraptor.observer.upload.MultipartConfig;
import br.com.caelum.vraptor.observer.upload.UploadSizeLimit;
import br.com.caelum.vraptor.validator.I18nMessage;
import br.com.caelum.vraptor.validator.Validator;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multiset;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CommonsUploadMultipartObserver {
    private static final Logger logger = LoggerFactory.getLogger(CommonsUploadMultipartObserver.class);

    public void upload(@Observes ControllerFound event, MutableRequest request, MultipartConfig config, Validator validator) {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return;
        }
        logger.info("Request contains multipart data. Try to parse with commons-upload.");
        HashMultiset indexes = HashMultiset.create();
        LinkedListMultimap params = LinkedListMultimap.create();
        ServletFileUpload uploader = this.createServletFileUpload(config);
        UploadSizeLimit uploadSizeLimit = event.getMethod().getMethod().getAnnotation(UploadSizeLimit.class);
        uploader.setSizeMax(uploadSizeLimit != null ? uploadSizeLimit.sizeLimit() : config.getSizeLimit());
        uploader.setFileSizeMax(uploadSizeLimit != null ? uploadSizeLimit.fileSizeLimit() : config.getFileSizeLimit());
        logger.debug("Setting file sizes: total={}, file={}", (Object)uploader.getSizeMax(), (Object)uploader.getFileSizeMax());
        try {
            List items = uploader.parseRequest((HttpServletRequest)request);
            logger.debug("Found {} attributes in the multipart form submission. Parsing them.", (Object)items.size());
            for (FileItem item : items) {
                String name = item.getFieldName();
                name = this.fixIndexedParameters(name, (Multiset<String>)indexes);
                if (item.isFormField()) {
                    logger.debug("{} is a field", (Object)name);
                    params.put((Object)name, (Object)this.getValue(item, (ServletRequest)request));
                    continue;
                }
                if (this.isNotEmpty(item)) {
                    logger.debug("{} is a file", (Object)name);
                    this.processFile(item, name, request);
                    continue;
                }
                logger.debug("A file field is empty: {}", (Object)item.getFieldName());
            }
            for (String paramName : params.keySet()) {
                Collection paramValues = params.get((Object)paramName);
                request.setParameter(paramName, paramValues.toArray(new String[paramValues.size()]));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.reportSizeLimitExceeded(e, validator);
        }
        catch (FileUploadException e) {
            this.reportFileUploadException(e, validator);
        }
    }

    private boolean isNotEmpty(FileItem item) {
        return !item.getName().isEmpty();
    }

    protected void reportSizeLimitExceeded(FileUploadBase.SizeLimitExceededException e, Validator validator) {
        validator.add(new I18nMessage("upload", "file.limit.exceeded", e.getActualSize(), e.getPermittedSize()));
        logger.warn("The file size limit was exceeded. Actual {} permitted {}", (Object)e.getActualSize(), (Object)e.getPermittedSize());
    }

    protected void reportFileUploadException(FileUploadException e, Validator validator) {
        validator.add(new I18nMessage("upload", "file.upload.exception", new Object[0]));
        logger.warn("There was some problem parsing this multipart request, or someone is not sending a RFC1867 compatible multipart request.", (Throwable)e);
    }

    protected void processFile(FileItem item, String name, MutableRequest request) {
        CommonsUploadedFile upload = new CommonsUploadedFile(item);
        request.setParameter(name, name);
        request.setAttribute(name, upload);
        logger.debug("Uploaded file: {} with {}", (Object)name, (Object)upload);
    }

    protected ServletFileUpload createServletFileUpload(MultipartConfig config) {
        DiskFileItemFactory factory = new DiskFileItemFactory(10240, config.getDirectory());
        logger.debug("Using repository {} for file upload", (Object)config.getDirectory());
        return new ServletFileUpload((FileItemFactory)factory);
    }

    protected String getValue(FileItem item, ServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (!Strings.isNullOrEmpty((String)encoding)) {
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("Request has an invalid encoding. Ignoring it", (Throwable)e);
            }
        }
        return item.getString();
    }

    protected String fixIndexedParameters(String name, Multiset<String> indexes) {
        if (name.contains("[]")) {
            String newName = name.replace("[]", "[" + indexes.count((Object)name) + "]");
            indexes.add((Object)name);
            logger.debug("{} was renamed to {}", (Object)name, (Object)newName);
            return newName;
        }
        return name;
    }
}

