/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.core.DeserializesQualifier;
import br.com.caelum.vraptor.serialization.Deserializer;
import br.com.caelum.vraptor.serialization.Deserializers;
import com.google.common.base.Preconditions;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@Dependent
public class DeserializesHandler {
    private final Deserializers deserializers;

    protected DeserializesHandler() {
        this(null);
    }

    @Inject
    public DeserializesHandler(Deserializers deserializers) {
        this.deserializers = deserializers;
    }

    public void handle(@Observes @DeserializesQualifier BeanClass beanClass) {
        Class<?> originalType = beanClass.getType();
        Preconditions.checkArgument((boolean)Deserializer.class.isAssignableFrom(originalType), (String)"%s must implement Deserializer", (Object[])new Object[]{beanClass});
        this.deserializers.register(originalType);
    }
}

