/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.core.ReflectionProvider;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class Serializee {
    private final ReflectionProvider reflectionProvider;
    private Object root;
    private Class<?> rootClass;
    private Multimap<String, Class<?>> includes;
    private Multimap<String, Class<?>> excludes;
    private Set<Class<?>> elementTypes;
    private boolean recursive;

    @Inject
    public Serializee(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public Class<?> getRootClass() {
        return this.rootClass;
    }

    public void setRootClass(Class<?> rootClass) {
        this.rootClass = rootClass;
    }

    public Multimap<String, Class<?>> getIncludes() {
        if (this.includes == null) {
            this.includes = LinkedListMultimap.create();
        }
        return this.includes;
    }

    public Multimap<String, Class<?>> getExcludes() {
        if (this.excludes == null) {
            this.excludes = LinkedListMultimap.create();
        }
        return this.excludes;
    }

    public Set<Class<?>> getElementTypes() {
        return this.elementTypes;
    }

    public void setElementTypes(Set<Class<?>> elementTypes) {
        this.elementTypes = elementTypes;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void excludeAll(String ... names) {
        for (String name : names) {
            this.getExcludes().putAll((Object)name.replaceAll("\\?", ""), this.getParentTypesFor(name));
        }
    }

    public void excludeAll() {
        HashSet types = new HashSet();
        if (Serializee.isCollection(this.getRootClass())) {
            types.addAll(this.getElementTypes());
        } else {
            types.add(this.getRootClass());
        }
        for (Class clazz : types) {
            for (Field field : this.reflectionProvider.getFieldsFor(clazz)) {
                this.getExcludes().putAll((Object)field.getName(), this.getParentTypes(field.getName(), clazz));
            }
        }
    }

    public void includeAll(String ... names) {
        for (String name : names) {
            this.getIncludes().putAll((Object)name.replaceAll("\\?", ""), this.getParentTypesFor(name));
        }
    }

    private Set<Class<?>> getParentTypesFor(String name) {
        if (this.getElementTypes() == null) {
            Class<?> type = this.getRootClass();
            return this.getParentTypes(name, type);
        }
        HashSet result = new HashSet();
        for (Class<?> type : this.getElementTypes()) {
            result.addAll(this.getParentTypes(name, type));
        }
        return result;
    }

    private Set<Class<?>> getParentTypes(String name, Class<?> type) {
        String[] path = name.split("\\.");
        try {
            Field field;
            for (int i = 0; i < path.length && (field = this.reflectField(path[i], type)) != null; ++i) {
                if (i >= path.length - 1) continue;
                type = this.getActualType(field);
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Field path '" + name + "' doesn't exists in " + type, e);
        }
        HashSet types = new HashSet();
        while (type != Object.class) {
            types.add(type);
            type = type.getSuperclass();
        }
        return types;
    }

    private Field reflectField(String path, Class<?> type) {
        Field field = this.reflectionProvider.getField(type, path.replaceAll("\\?", ""));
        if (!path.startsWith("?")) {
            Objects.requireNonNull(field);
        }
        return field;
    }

    protected Class<?> getActualType(Field field) {
        ParameterizedType type;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && Serializee.isCollection(type = (ParameterizedType)genericType)) {
            Type actualType = type.getActualTypeArguments()[0];
            if (actualType instanceof TypeVariable) {
                return (Class)type.getRawType();
            }
            return (Class)actualType;
        }
        return (Class)genericType;
    }

    private static boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return Collection.class.isAssignableFrom((Class)ptype.getRawType()) || Map.class.isAssignableFrom((Class)ptype.getRawType());
        }
        return Collection.class.isAssignableFrom((Class)type);
    }
}

